package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ContactV2 implements Serializable {

    @JsonProperty("name")
    private String name;

    @JsonProperty("phone")
    private String phone;

    @JsonProperty("email")
    private String email;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String toString() {
        return "ContactV2 [" +
                ((name != null) ? "name='" + name + "', " : "") +
                ((phone != null) ? "phone='" + phone + "', " : "") +
                ((email != null) ? "email='" + email + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ContactV2 contactV2 = (ContactV2) o;
        return Objects.equals(name, contactV2.name) && Objects.equals(phone, contactV2.phone) && Objects.equals(email, contactV2.email);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, phone, email);
    }
}