package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TokenOAuth2Nera implements Serializable {

    @JsonProperty("accessToken")
    private String accessToken = null;

    @JsonProperty("refreshToken")
    private String refreshToken = null;

    @JsonProperty("idToken")
    private String idToken = null;

    @JsonProperty("tokenType")
    private String tokenType = null;

    @JsonProperty("expiresIn")
    private Integer expiresIn = null;

    @JsonProperty("scope")
    private String scope = null;

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getIdToken() {
        return idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public String toString() {
        return "TokenOAuth2Nera [" +
                ((accessToken != null) ? "accessToken='" + accessToken + "', " : "") +
                ((refreshToken != null) ? "refreshToken='" + refreshToken + "', " : "") +
                ((idToken != null) ? "idToken='" + idToken + "', " : "") +
                ((tokenType != null) ? "tokenType='" + tokenType + "', " : "") +
                ((expiresIn != null) ? "expiresIn=" + expiresIn + ", " : "") +
                ((scope != null) ? "scope='" + scope + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TokenOAuth2Nera that = (TokenOAuth2Nera) o;
        return Objects.equals(accessToken, that.accessToken) && Objects.equals(refreshToken, that.refreshToken) && Objects.equals(idToken, that.idToken) && Objects.equals(tokenType, that.tokenType) && Objects.equals(expiresIn, that.expiresIn) && Objects.equals(scope, that.scope);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accessToken, refreshToken, idToken, tokenType, expiresIn, scope);
    }
}