package ar.com.sdd.creditosimple.io.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EligibilityV2Request implements Serializable {

    @JsonProperty("partner_key_name")
    private String partnerKeyName;
    
    @JsonProperty("product_key_name")
    private String productKeyName;
    
    @JsonProperty("farmer_cuit")
    private String farmerCuit;
    
    @JsonProperty("merchant_cuit")
    private String merchantCuit;
    
    @JsonProperty("farmer_user_email")
    private String farmerUserEmail;

    public String getPartnerKeyName() {
        return partnerKeyName;
    }

    public void setPartnerKeyName(String partnerKeyName) {
        this.partnerKeyName = partnerKeyName;
    }

    public String getProductKeyName() {
        return productKeyName;
    }

    public void setProductKeyName(String productKeyName) {
        this.productKeyName = productKeyName;
    }

    public String getFarmerCuit() {
        return farmerCuit;
    }

    public void setFarmerCuit(String farmerCuit) {
        this.farmerCuit = farmerCuit;
    }

    public String getMerchantCuit() {
        return merchantCuit;
    }

    public void setMerchantCuit(String merchantCuit) {
        this.merchantCuit = merchantCuit;
    }

    public String getFarmerUserEmail() {
        return farmerUserEmail;
    }

    public void setFarmerUserEmail(String farmerUserEmail) {
        this.farmerUserEmail = farmerUserEmail;
    }

    @Override
    public String toString() {
        return "EligibilityV2Request [" +
                ((partnerKeyName != null) ? "partnerKeyName='" + partnerKeyName + "', " : "") +
                ((productKeyName != null) ? "productKeyName='" + productKeyName + "', " : "") +
                ((farmerCuit != null) ? "farmerCuit='" + farmerCuit + "', " : "") +
                ((merchantCuit != null) ? "merchantCuit='" + merchantCuit + "', " : "") +
                ((farmerUserEmail != null) ? "farmerUserEmail='" + farmerUserEmail + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EligibilityV2Request that = (EligibilityV2Request) o;
        return Objects.equals(partnerKeyName, that.partnerKeyName) && Objects.equals(productKeyName, that.productKeyName) && Objects.equals(farmerCuit, that.farmerCuit) && Objects.equals(merchantCuit, that.merchantCuit) && Objects.equals(farmerUserEmail, that.farmerUserEmail);
    }

    @Override
    public int hashCode() {
        return Objects.hash(partnerKeyName, productKeyName, farmerCuit, merchantCuit, farmerUserEmail);
    }
}