package ar.com.sdd.creditosimple.io.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EligibilityV2Response implements Serializable {

    @JsonProperty("is_eligible")
    private Boolean isEligible;
    
    @JsonProperty("reasons")
    private List<String> reasons;

    public Boolean getEligible() {
        return isEligible;
    }

    public void setEligible(Boolean eligible) {
        isEligible = eligible;
    }

    public List<String> getReasons() {
        return reasons;
    }

    public void setReasons(List<String> reasons) {
        this.reasons = reasons;
    }

    @Override
    public String toString() {
        return "EligibilityV2Response [" +
                ((isEligible != null) ? "isEligible=" + isEligible + ", " : "") +
                ((reasons != null) ? "reasons=" + Arrays.toString(reasons.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EligibilityV2Response that = (EligibilityV2Response) o;
        return Objects.equals(isEligible, that.isEligible) && Objects.equals(reasons, that.reasons);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isEligible, reasons);
    }
}