/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ConvenioV1 {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private String id;
    @JsonProperty(value="cantidad_cuotas")
    private Integer cantidadCuotas;
    @JsonProperty(value="fecha_primer_vencimiento")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="GMT-03:00")
    private Date fechaPrimerVencimiento;
    @JsonProperty(value="tna_productor")
    private BigDecimal tnaProductor;
    @JsonProperty(value="periodo_meses")
    private Integer periodoMeses;
    @JsonProperty(value="tipo_financiacion")
    private String tipoFinanciacion;
    @JsonProperty(value="id_empresa")
    private String idEmpresa;
    @JsonProperty(value="id_producto")
    private String idProducto;
    @JsonProperty(value="tipo_prestamo")
    private String tipoPrestamo;

    public String getDescription() {
        StringBuilder result = new StringBuilder();
        result.append(this.tipoFinanciacion.toLowerCase()).append("(");
        if (this.cantidadCuotas != null) {
            result.append(this.cantidadCuotas).append(" cuotas");
        }
        if (this.fechaPrimerVencimiento != null) {
            result.append(" vto:").append(sdf.format(this.fechaPrimerVencimiento)).append(",");
        }
        if (this.tnaProductor != null) {
            result.append(" TNA:").append(this.tnaProductor.setScale(2, RoundingMode.HALF_UP)).append("%");
        }
        result.append(")");
        return result.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getCantidadCuotas() {
        return this.cantidadCuotas;
    }

    public void setCantidadCuotas(Integer cantidadCuotas) {
        this.cantidadCuotas = cantidadCuotas;
    }

    public Date getFechaPrimerVencimiento() {
        return this.fechaPrimerVencimiento;
    }

    public void setFechaPrimerVencimiento(Date fechaPrimerVencimiento) {
        this.fechaPrimerVencimiento = fechaPrimerVencimiento;
    }

    public BigDecimal getTnaProductor() {
        return this.tnaProductor;
    }

    public void setTnaProductor(BigDecimal tnaProductor) {
        this.tnaProductor = tnaProductor;
    }

    public Integer getPeriodoMeses() {
        return this.periodoMeses;
    }

    public void setPeriodoMeses(Integer periodoMeses) {
        this.periodoMeses = periodoMeses;
    }

    public String getTipoFinanciacion() {
        return this.tipoFinanciacion;
    }

    public void setTipoFinanciacion(String tipoFinanciacion) {
        this.tipoFinanciacion = tipoFinanciacion;
    }

    public String getIdEmpresa() {
        return this.idEmpresa;
    }

    public void setIdEmpresa(String idEmpresa) {
        this.idEmpresa = idEmpresa;
    }

    public String getIdProducto() {
        return this.idProducto;
    }

    public void setIdProducto(String idProducto) {
        this.idProducto = idProducto;
    }

    public String getTipoPrestamo() {
        return this.tipoPrestamo;
    }

    public void setTipoPrestamo(String tipoPrestamo) {
        this.tipoPrestamo = tipoPrestamo;
    }

    public String toString() {
        return "Convenio [id=" + this.id + ", cantidadCuotas=" + this.cantidadCuotas + ", fechaPrimerVencimiento=" + this.fechaPrimerVencimiento + ", tnaProductor=" + this.tnaProductor + ", periodoMeses=" + this.periodoMeses + ", tipoFinanciacion=" + this.tipoFinanciacion + ", idEmpresa=" + this.idEmpresa + ", idProducto=" + this.idProducto + ", tipoPrestamo=" + this.tipoPrestamo + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvenioV1 convenio = (ConvenioV1)o;
        if (!Objects.equals(this.id, convenio.id)) {
            return false;
        }
        if (!Objects.equals(this.cantidadCuotas, convenio.cantidadCuotas)) {
            return false;
        }
        if (!Objects.equals(this.fechaPrimerVencimiento, convenio.fechaPrimerVencimiento)) {
            return false;
        }
        if (!Objects.equals(this.tnaProductor, convenio.tnaProductor)) {
            return false;
        }
        if (!Objects.equals(this.periodoMeses, convenio.periodoMeses)) {
            return false;
        }
        if (!Objects.equals(this.tipoFinanciacion, convenio.tipoFinanciacion)) {
            return false;
        }
        if (!Objects.equals(this.idEmpresa, convenio.idEmpresa)) {
            return false;
        }
        if (!Objects.equals(this.idProducto, convenio.idProducto)) {
            return false;
        }
        return Objects.equals(this.tipoPrestamo, convenio.tipoPrestamo);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.cantidadCuotas != null ? this.cantidadCuotas.hashCode() : 0);
        result = 31 * result + (this.fechaPrimerVencimiento != null ? this.fechaPrimerVencimiento.hashCode() : 0);
        result = 31 * result + (this.tnaProductor != null ? this.tnaProductor.hashCode() : 0);
        result = 31 * result + (this.periodoMeses != null ? this.periodoMeses.hashCode() : 0);
        result = 31 * result + (this.tipoFinanciacion != null ? this.tipoFinanciacion.hashCode() : 0);
        result = 31 * result + (this.idEmpresa != null ? this.idEmpresa.hashCode() : 0);
        result = 31 * result + (this.idProducto != null ? this.idProducto.hashCode() : 0);
        result = 31 * result + (this.tipoPrestamo != null ? this.tipoPrestamo.hashCode() : 0);
        return result;
    }
}

