package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConvenioV1 {
    /* Sample:
    "id": "63987c3c6a3416000117dfc5",
    "cantidad_cuotas": 1,
    "fecha_primer_vencimiento": "2023-12-01",
    "tna_productor": 95.0,
    "periodo_meses": 0,
    "tipo_financiacion": "Combustible Vto Diciembre 2023",
    "tna_proveedor": 0.0,
    "cod_tipo_financiacion": "-",
    "id_empresa": "268",
    "id_producto": "2",
    "tipo_prestamo": "1"
            **/
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");

    private String id;

    @JsonProperty("cantidad_cuotas")
    private Integer cantidadCuotas;

    @JsonProperty("fecha_primer_vencimiento")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaPrimerVencimiento;

    @JsonProperty("tna_productor")
    private BigDecimal tnaProductor;

    @JsonProperty("periodo_meses")
    private Integer periodoMeses;

    @JsonProperty("tipo_financiacion")
    private String tipoFinanciacion;

    @JsonProperty("id_empresa")
    private String idEmpresa;

    @JsonProperty("id_producto")
    private String idProducto;

    @JsonProperty("tipo_prestamo")
    private String tipoPrestamo;

    //NO eliminar
    public String getDescription() {
        StringBuilder result = new StringBuilder();

        result.append(tipoFinanciacion.toLowerCase()).append("(");
        if (cantidadCuotas != null) {
            result.append(cantidadCuotas).append(" cuotas");
        }
        if (fechaPrimerVencimiento != null) {
            result.append(" vto:").append(sdf.format(fechaPrimerVencimiento)).append(",");
        }
        if (tnaProductor != null) {
            result.append(" TNA:").append(tnaProductor.setScale(2, RoundingMode.HALF_UP)).append("%");
        }
        result.append(")");

        return result.toString();
    }


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getCantidadCuotas() {
        return cantidadCuotas;
    }

    public void setCantidadCuotas(Integer cantidadCuotas) {
        this.cantidadCuotas = cantidadCuotas;
    }

    public Date getFechaPrimerVencimiento() {
        return fechaPrimerVencimiento;
    }

    public void setFechaPrimerVencimiento(Date fechaPrimerVencimiento) {
        this.fechaPrimerVencimiento = fechaPrimerVencimiento;
    }

    public BigDecimal getTnaProductor() {
        return tnaProductor;
    }

    public void setTnaProductor(BigDecimal tnaProductor) {
        this.tnaProductor = tnaProductor;
    }

    public Integer getPeriodoMeses() {
        return periodoMeses;
    }

    public void setPeriodoMeses(Integer periodoMeses) {
        this.periodoMeses = periodoMeses;
    }

    public String getTipoFinanciacion() {
        return tipoFinanciacion;
    }

    public void setTipoFinanciacion(String tipoFinanciacion) {
        this.tipoFinanciacion = tipoFinanciacion;
    }

    public String getIdEmpresa() {
        return idEmpresa;
    }

    public void setIdEmpresa(String idEmpresa) {
        this.idEmpresa = idEmpresa;
    }

    public String getIdProducto() {
        return idProducto;
    }

    public void setIdProducto(String idProducto) {
        this.idProducto = idProducto;
    }

    public String getTipoPrestamo() {
        return tipoPrestamo;
    }

    public void setTipoPrestamo(String tipoPrestamo) {
        this.tipoPrestamo = tipoPrestamo;
    }


    @Override
    public String toString() {
        return "Convenio [" +
                "id=" + id +
                ", cantidadCuotas=" + cantidadCuotas +
                ", fechaPrimerVencimiento=" + fechaPrimerVencimiento +
                ", tnaProductor=" + tnaProductor +
                ", periodoMeses=" + periodoMeses +
                ", tipoFinanciacion=" + tipoFinanciacion +
                ", idEmpresa=" + idEmpresa +
                ", idProducto=" + idProducto +
                ", tipoPrestamo=" + tipoPrestamo +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConvenioV1 convenio = (ConvenioV1) o;

        if (!Objects.equals(id, convenio.id)) return false;
        if (!Objects.equals(cantidadCuotas, convenio.cantidadCuotas)) return false;
        if (!Objects.equals(fechaPrimerVencimiento, convenio.fechaPrimerVencimiento)) return false;
        if (!Objects.equals(tnaProductor, convenio.tnaProductor)) return false;
        if (!Objects.equals(periodoMeses, convenio.periodoMeses)) return false;
        if (!Objects.equals(tipoFinanciacion, convenio.tipoFinanciacion)) return false;
        if (!Objects.equals(idEmpresa, convenio.idEmpresa)) return false;
        if (!Objects.equals(idProducto, convenio.idProducto)) return false;
        return Objects.equals(tipoPrestamo, convenio.tipoPrestamo);
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (cantidadCuotas != null ? cantidadCuotas.hashCode() : 0);
        result = 31 * result + (fechaPrimerVencimiento != null ? fechaPrimerVencimiento.hashCode() : 0);
        result = 31 * result + (tnaProductor != null ? tnaProductor.hashCode() : 0);
        result = 31 * result + (periodoMeses != null ? periodoMeses.hashCode() : 0);
        result = 31 * result + (tipoFinanciacion != null ? tipoFinanciacion.hashCode() : 0);
        result = 31 * result + (idEmpresa != null ? idEmpresa.hashCode() : 0);
        result = 31 * result + (idProducto != null ? idProducto.hashCode() : 0);
        result = 31 * result + (tipoPrestamo != null ? tipoPrestamo.hashCode() : 0);
        return result;
    }
}

