/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.creditosimple.core.galicia;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.creditosimple.core.galicia.CreditoSimpleGaliciaV1ConnectorContext;
import ar.com.sdd.creditosimple.io.galicia.ConveniosV1Response;
import ar.com.sdd.creditosimple.io.galicia.ErrorV1Response;
import ar.com.sdd.creditosimple.io.galicia.OrdenV1Request;
import ar.com.sdd.creditosimple.io.galicia.OrdenesV1Response;
import ar.com.sdd.creditosimple.io.galicia.SimulacionV1Request;
import ar.com.sdd.creditosimple.io.galicia.Simulacionv1Response;
import java.util.HashMap;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreditoSimpleGaliciaV1Connector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(CreditoSimpleGaliciaV1Connector.class);
    private final RestConnector restConnector;
    private final String appId;
    private final String appKey;

    public CreditoSimpleGaliciaV1Connector(CreditoSimpleGaliciaV1ConnectorContext context) {
        String baseUrl = context.getBaseUrl();
        this.appId = context.getAppId();
        this.appKey = context.getAppKey();
        log.debug("Creando conector para CreditoSimple Galicia con baseUrl [" + baseUrl + "], appId [" + this.appId + "], appKey [" + this.appKey + "]");
        RestConnectorEnvironment environment = new RestConnectorEnvironment(baseUrl, null, null, null, null);
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public void getValidarCuit(String cuit) throws RestConnectorException {
        this.getValidarCuit(cuit, "1");
    }

    public void getValidarCuit(String cuit, String productId) throws RestConnectorException {
        log.debug("[getValidarCuit] Request GET validar con cuit [" + cuit + "]");
        HashMap<String, String> templateParameters = new HashMap<String, String>();
        templateParameters.put("cuit", cuit);
        templateParameters.put("productId", productId);
        this.restConnector.genericGetTextResponse(null, ErrorV1Response.class, "/validar/{cuit}/{productId}", templateParameters);
        log.debug("[getValidarCuit] Response GET validar [OK]");
    }

    public ConveniosV1Response getConvenios() throws RestConnectorException {
        return this.getConvenios(null, null, null);
    }

    public ConveniosV1Response getConvenios(String cuit, String segmentName, String productId) throws RestConnectorException {
        log.debug("[getConvenios] Request GET convenios con cuit[" + cuit + "]segment_name[" + segmentName + "]productId[" + productId + "]");
        Object path = "/convenios";
        HashMap<String, String> templateParameters = new HashMap<String, String>();
        if (productId != null && !productId.isEmpty()) {
            templateParameters.put("productId", productId);
            path = (String)path + "/{productId}";
        }
        String sep = "?";
        if (cuit != null && !cuit.isEmpty()) {
            path = (String)path + sep + "cuit=" + cuit;
            sep = "&";
        }
        if (segmentName != null && !segmentName.isEmpty()) {
            path = (String)path + sep + "segment_name=" + segmentName;
            sep = "&";
        }
        ConveniosV1Response response = (ConveniosV1Response)this.restConnector.genericGet(null, ConveniosV1Response.class, ErrorV1Response.class, (String)path, templateParameters);
        log.debug("[getConvenios] Response GET convenios [" + response + "]");
        return response;
    }

    public Simulacionv1Response postSimulacion(SimulacionV1Request simulacionRequest) throws RestConnectorException {
        log.debug("[postSimulacion] Request POST simulacion [" + simulacionRequest + "]");
        String path = "/simulacion";
        Simulacionv1Response response = (Simulacionv1Response)this.restConnector.genericPost((Object)simulacionRequest, Simulacionv1Response.class, ErrorV1Response.class, path);
        log.debug("[postSimulacion] Response POST simulacion [" + response + "]");
        return response;
    }

    public OrdenesV1Response postOrden(OrdenV1Request ordenRequest) throws RestConnectorException {
        log.debug("[postOrden] Request POST orden [" + ordenRequest + "]");
        String path = "/orders";
        OrdenesV1Response response = (OrdenesV1Response)this.restConnector.genericPost((Object)ordenRequest, OrdenesV1Response.class, ErrorV1Response.class, path);
        log.debug("[postOrden] Response POST orden [" + response + "]");
        return response;
    }

    public OrdenesV1Response getOrdenes() throws RestConnectorException {
        log.debug("[getOrdenes] Request GET ordenes sin parametros");
        String path = "/orders";
        OrdenesV1Response response = (OrdenesV1Response)this.restConnector.genericGet(null, OrdenesV1Response.class, ErrorV1Response.class, path);
        log.debug("[getOrdenes] Response GET ordenes [" + response + "]");
        return response;
    }

    public OrdenesV1Response getOrden(String idOrden) throws RestConnectorException {
        log.debug("[getOrden] Request GET orden con idOrden [" + idOrden + "]");
        OrdenesV1Response response = (OrdenesV1Response)this.restConnector.genericGet(null, OrdenesV1Response.class, ErrorV1Response.class, "/orders/{id_orden}", "id_orden", idOrden);
        log.debug("[getOrden] Response GET orden [" + response + "]");
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) {
        builder.header("app_id", (Object)this.appId);
        builder.header("x-api-key", (Object)this.appKey);
        builder.header("app_key", (Object)this.appKey);
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }
}

