package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AddressV2 implements Serializable {

    @JsonProperty("between_street_1")
    private String betweenStreet1;

    @JsonProperty("between_street_2")
    private String betweenStreet2;

    @JsonProperty("city_name")
    private String cityName;

    @JsonProperty("country_code")
    private String countryCode;

    @JsonProperty("country_name")
    private String countryName;

    @JsonProperty("cpa")
    private String cpa;

    @JsonProperty("door_number")
    private String doorNumber;

    @JsonProperty("floor_number")
    private String floorNumber;

    @JsonProperty("is_main_address")//: true,
    private Boolean isMainAddress;

    @JsonProperty("latitude")
    private String latitude;

    @JsonProperty("location_name")
    private String locationName;

    @JsonProperty("longitude")
    private String longitude;

    @JsonProperty("postal_code")
    private String postalCode;

    @JsonProperty("province_code")
    private String provinceCode;

    @JsonProperty("province_name")
    private String provinceName;

    @JsonProperty("street")
    private String street;

    @JsonProperty("street_abbreviated")
    private String streetAbbreviated;

    @JsonProperty("use_code")
    private String useCode;

    public String getBetweenStreet1() {
        return betweenStreet1;
    }

    public void setBetweenStreet1(String betweenStreet1) {
        this.betweenStreet1 = betweenStreet1;
    }

    public String getBetweenStreet2() {
        return betweenStreet2;
    }

    public void setBetweenStreet2(String betweenStreet2) {
        this.betweenStreet2 = betweenStreet2;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getCpa() {
        return cpa;
    }

    public void setCpa(String cpa) {
        this.cpa = cpa;
    }

    public String getDoorNumber() {
        return doorNumber;
    }

    public void setDoorNumber(String doorNumber) {
        this.doorNumber = doorNumber;
    }

    public String getFloorNumber() {
        return floorNumber;
    }

    public void setFloorNumber(String floorNumber) {
        this.floorNumber = floorNumber;
    }

    public Boolean getMainAddress() {
        return isMainAddress;
    }

    public void setMainAddress(Boolean mainAddress) {
        isMainAddress = mainAddress;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLocationName() {
        return locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getStreetAbbreviated() {
        return streetAbbreviated;
    }

    public void setStreetAbbreviated(String streetAbbreviated) {
        this.streetAbbreviated = streetAbbreviated;
    }

    public String getUseCode() {
        return useCode;
    }

    public void setUseCode(String useCode) {
        this.useCode = useCode;
    }

    @Override
    public String toString() {
        return "AddressV2 [" +
                ((betweenStreet1 != null) ? "betweenStreet1='" + betweenStreet1 + "', " : "") +
                ((betweenStreet2 != null) ? "betweenStreet2='" + betweenStreet2 + "', " : "") +
                ((cityName != null) ? "cityName='" + cityName + "', " : "") +
                ((countryCode != null) ? "countryCode='" + countryCode + "', " : "") +
                ((countryName != null) ? "countryName='" + countryName + "', " : "") +
                ((cpa != null) ? "cpa='" + cpa + "', " : "") +
                ((doorNumber != null) ? "doorNumber='" + doorNumber + "', " : "") +
                ((floorNumber != null) ? "floorNumber='" + floorNumber + "', " : "") +
                ((isMainAddress != null) ? "isMainAddress=" + isMainAddress + ", " : "") +
                ((latitude != null) ? "latitude='" + latitude + "', " : "") +
                ((locationName != null) ? "locationName='" + locationName + "', " : "") +
                ((longitude != null) ? "longitude='" + longitude + "', " : "") +
                ((postalCode != null) ? "postalCode='" + postalCode + "', " : "") +
                ((provinceCode != null) ? "provinceCode='" + provinceCode + "', " : "") +
                ((provinceName != null) ? "provinceName='" + provinceName + "', " : "") +
                ((street != null) ? "street='" + street + "', " : "") +
                ((streetAbbreviated != null) ? "streetAbbreviated='" + streetAbbreviated + "', " : "") +
                ((useCode != null) ? "useCode='" + useCode + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AddressV2 addressV2 = (AddressV2) o;
        return Objects.equals(betweenStreet1, addressV2.betweenStreet1) && Objects.equals(betweenStreet2, addressV2.betweenStreet2) && Objects.equals(cityName, addressV2.cityName) && Objects.equals(countryCode, addressV2.countryCode) && Objects.equals(countryName, addressV2.countryName) && Objects.equals(cpa, addressV2.cpa) && Objects.equals(doorNumber, addressV2.doorNumber) && Objects.equals(floorNumber, addressV2.floorNumber) && Objects.equals(isMainAddress, addressV2.isMainAddress) && Objects.equals(latitude, addressV2.latitude) && Objects.equals(locationName, addressV2.locationName) && Objects.equals(longitude, addressV2.longitude) && Objects.equals(postalCode, addressV2.postalCode) && Objects.equals(provinceCode, addressV2.provinceCode) && Objects.equals(provinceName, addressV2.provinceName) && Objects.equals(street, addressV2.street) && Objects.equals(streetAbbreviated, addressV2.streetAbbreviated) && Objects.equals(useCode, addressV2.useCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(betweenStreet1, betweenStreet2, cityName, countryCode, countryName, cpa, doorNumber, floorNumber, isMainAddress, latitude, locationName, longitude, postalCode, provinceCode, provinceName, street, streetAbbreviated, useCode);
    }
}