package ar.com.sdd.creditosimple.io.galicia;

import ar.com.sdd.creditosimple.entity.galicia.ContactV2;
import ar.com.sdd.creditosimple.entity.galicia.FarmerV2;
import ar.com.sdd.creditosimple.entity.galicia.MerchantV2;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class OrderV2Request implements Serializable {

    @JsonProperty("partner_key_name")
    private String partnerKeyName;

    @JsonProperty("product_key_name")
    private String productKeyName;

    @JsonProperty("simulation_id")
    private String simulationId;

    @JsonProperty("title")
    private String title;

    @JsonProperty("farmer")
    private FarmerV2 farmer;

    @JsonProperty("merchant")
    private MerchantV2 merchant;

    @JsonProperty("contact")
    private ContactV2 contact;

    public String getPartnerKeyName() {
        return partnerKeyName;
    }

    public void setPartnerKeyName(String partnerKeyName) {
        this.partnerKeyName = partnerKeyName;
    }

    public String getProductKeyName() {
        return productKeyName;
    }

    public void setProductKeyName(String productKeyName) {
        this.productKeyName = productKeyName;
    }

    public String getSimulationId() {
        return simulationId;
    }

    public void setSimulationId(String simulationId) {
        this.simulationId = simulationId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public FarmerV2 getFarmer() {
        return farmer;
    }

    public void setFarmer(FarmerV2 farmer) {
        this.farmer = farmer;
    }

    public MerchantV2 getMerchant() {
        return merchant;
    }

    public void setMerchant(MerchantV2 merchant) {
        this.merchant = merchant;
    }

    public ContactV2 getContact() {
        return contact;
    }

    public void setContact(ContactV2 contact) {
        this.contact = contact;
    }

    @Override
    public String toString() {
        return "OrderV2Request [" +
                ((partnerKeyName != null) ? "partnerKeyName='" + partnerKeyName + "', " : "") +
                ((productKeyName != null) ? "productKeyName='" + productKeyName + "', " : "") +
                ((simulationId != null) ? "simulationId='" + simulationId + "', " : "") +
                ((title != null) ? "title='" + title + "', " : "") +
                ((farmer != null) ? "farmer=" + farmer + ", " : "") +
                ((merchant != null) ? "merchant=" + merchant + ", " : "") +
                ((contact != null) ? "contact=" + contact + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrderV2Request that = (OrderV2Request) o;
        return Objects.equals(partnerKeyName, that.partnerKeyName) && Objects.equals(productKeyName, that.productKeyName) && Objects.equals(simulationId, that.simulationId) && Objects.equals(title, that.title) && Objects.equals(farmer, that.farmer) && Objects.equals(merchant, that.merchant) && Objects.equals(contact, that.contact);
    }

    @Override
    public int hashCode() {
        return Objects.hash(partnerKeyName, productKeyName, simulationId, title, farmer, merchant, contact);
    }
}