package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PartnerV2 implements Serializable {

    @JsonProperty("name")
    private String name;

    @JsonProperty("partner_cuit")
    private String partnerCuit;

    @JsonProperty("partner_key_name")
    private String partnerKeyName;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPartnerCuit() {
        return partnerCuit;
    }

    public void setPartnerCuit(String partnerCuit) {
        this.partnerCuit = partnerCuit;
    }

    public String getPartnerKeyName() {
        return partnerKeyName;
    }

    public void setPartnerKeyName(String partnerKeyName) {
        this.partnerKeyName = partnerKeyName;
    }

    @Override
    public String toString() {
        return "PartnerV2 [" +
                ((name != null) ? "name='" + name + "', " : "") +
                ((partnerCuit != null) ? "partnerCuit='" + partnerCuit + "', " : "") +
                ((partnerKeyName != null) ? "partnerKeyName='" + partnerKeyName + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PartnerV2 partnerV2 = (PartnerV2) o;
        return Objects.equals(name, partnerV2.name) && Objects.equals(partnerCuit, partnerV2.partnerCuit) && Objects.equals(partnerKeyName, partnerV2.partnerKeyName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, partnerCuit, partnerKeyName);
    }
}