package ar.com.sdd.creditosimple.io.galicia;

import ar.com.sdd.creditosimple.entity.galicia.ContactV2;
import ar.com.sdd.creditosimple.entity.galicia.FarmerV2;
import ar.com.sdd.creditosimple.entity.galicia.MerchantV2;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class OrderV2Response implements Serializable {

    @JsonProperty("order_id")
    private String orderId;

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @Override
    public String toString() {
        return "OrderV2Response [" +
                ((orderId != null) ? "orderId='" + orderId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrderV2Response that = (OrderV2Response) o;
        return Objects.equals(orderId, that.orderId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderId);
    }
}