/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.creditosimple.core.galicia;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.creditosimple.core.galicia.CreditoSimpleNeraV2ConnectorContext;
import ar.com.sdd.creditosimple.entity.galicia.AgreementV2;
import ar.com.sdd.creditosimple.entity.galicia.FarmerV2;
import ar.com.sdd.creditosimple.entity.galicia.OrderV2;
import ar.com.sdd.creditosimple.entity.galicia.PartnerV2;
import ar.com.sdd.creditosimple.entity.galicia.ProductV2;
import ar.com.sdd.creditosimple.entity.galicia.TokenOAuth2Nera;
import ar.com.sdd.creditosimple.io.galicia.CreditCalculationV2Request;
import ar.com.sdd.creditosimple.io.galicia.CreditCalculationV2Response;
import ar.com.sdd.creditosimple.io.galicia.EligibilityV2Request;
import ar.com.sdd.creditosimple.io.galicia.EligibilityV2Response;
import ar.com.sdd.creditosimple.io.galicia.ErrorV2Response;
import ar.com.sdd.creditosimple.io.galicia.OrderV2Request;
import ar.com.sdd.creditosimple.io.galicia.OrderV2Response;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreditoSimpleNeraV2Connector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(CreditoSimpleNeraV2Connector.class);
    private final RestConnector restConnector;
    private final String email;
    private final String password;
    private final SimpleCache cache = SimpleCacheManager.getInstance().getCache(CreditoSimpleNeraV2Connector.class.getName());
    private final String accessTokenCacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"accessToken"});
    private final String refreshTokenCacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"refreshToken"});
    private final String idTokenCacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"idToken"});
    private boolean doingLogin;

    public CreditoSimpleNeraV2Connector(CreditoSimpleNeraV2ConnectorContext context) {
        String baseUrl = context.getBaseUrl();
        this.email = context.getEmail();
        this.password = context.getPassword();
        log.debug("Creando conector para CreditoSimple Galicia con baseUrl [" + baseUrl + "], email [" + this.email + "] y password [" + this.password + "]");
        RestConnectorEnvironment environment = new RestConnectorEnvironment(baseUrl, context.getKeyStorePath(), context.getKeyStorePassword(), null, null);
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public ProductV2[] getProducts() throws RestConnectorException {
        String path = "/products";
        log.debug("[getProducts] Por consultar productos con path [{}]", (Object)"/products");
        return (ProductV2[])this.restConnector.genericGet(null, ProductV2[].class, ErrorV2Response.class, "/products");
    }

    public ProductV2 getProductByKeyName(String productKeyName) throws RestConnectorException {
        String path = "/products/" + productKeyName;
        log.debug("[getProducts] Por consultar producto con keyName [{}] y path [{}]", (Object)productKeyName, (Object)path);
        return (ProductV2)this.restConnector.genericGet(null, ProductV2.class, ErrorV2Response.class, path);
    }

    public PartnerV2[] getPartners() throws RestConnectorException {
        String path = "/partners";
        log.debug("[getPartners] Por consultar partners con path [{}]", (Object)"/partners");
        return (PartnerV2[])this.restConnector.genericGet(null, PartnerV2[].class, ErrorV2Response.class, "/partners");
    }

    public PartnerV2 getPartnerByKeyName(String productKeyName) throws RestConnectorException {
        String path = "/partners/" + productKeyName;
        log.debug("[getPartners] Por consultar partners con keyName [{}] y path [{}]", (Object)productKeyName, (Object)path);
        return (PartnerV2)this.restConnector.genericGet(null, PartnerV2.class, ErrorV2Response.class, path);
    }

    public String[] getAgreementsLoanTypes() throws RestConnectorException {
        String path = "/agreements/loan-types";
        log.debug("[getAgreementsLoanTypes] Por consultar tipos de prestamos de convenios con path [{}]", (Object)"/agreements/loan-types");
        return (String[])this.restConnector.genericGet(null, String[].class, ErrorV2Response.class, "/agreements/loan-types");
    }

    public AgreementV2 getAgreementDetails(Long agreementId) throws RestConnectorException {
        String path = "/agreements/details/" + agreementId;
        log.debug("[getAgreementsLoanTypes] Por consultar detalles convenio [{}] con path [{}]", (Object)agreementId, (Object)path);
        return (AgreementV2)this.restConnector.genericGet(null, AgreementV2.class, ErrorV2Response.class, path);
    }

    public AgreementV2[] getAgreementsByMerchantCuit(String merchantCuit, String segmentName, String loanType, String farmerCuit, String productId, String partnerCuit, String productKeyName) throws RestConnectorException {
        return this.getAgreements(merchantCuit, null, loanType, farmerCuit, productId, partnerCuit, productKeyName);
    }

    public AgreementV2[] getAgreementsByMerchantCuitAndSegmentName(String merchantCuit, String segmentName, String loanType, String farmerCuit, String productId, String partnerCuit, String productKeyName) throws RestConnectorException {
        return this.getAgreements(merchantCuit, segmentName, loanType, farmerCuit, productId, partnerCuit, productKeyName);
    }

    private AgreementV2[] getAgreements(String merchantCuit, String segmentName, String loanType, String farmerCuit, String productId, String partnerCuit, String productKeyName) throws RestConnectorException {
        String path = "/agreements/" + merchantCuit;
        if (StringUtil.isNotEmpty((String)segmentName)) {
            path = path + "/segments/" + segmentName;
        }
        char paramSep = '?';
        if (StringUtil.isNotEmpty((String)loanType)) {
            path = path + paramSep + "loan_type=" + loanType;
            paramSep = '&';
        }
        if (StringUtil.isNotEmpty((String)farmerCuit)) {
            path = path + paramSep + "farmer_cuit=" + farmerCuit;
            paramSep = '&';
        }
        if (StringUtil.isNotEmpty((String)productId)) {
            path = path + paramSep + "product_id=" + productId;
            paramSep = '&';
        }
        if (StringUtil.isNotEmpty((String)partnerCuit)) {
            path = path + paramSep + "partner_cuit=" + partnerCuit;
            paramSep = '&';
        }
        if (StringUtil.isNotEmpty((String)productKeyName)) {
            path = path + paramSep + "product_key_name=" + productKeyName;
        }
        log.debug("[getAgreements] Por consultar convenios con path [{}]", (Object)path);
        return (AgreementV2[])this.restConnector.genericGet(null, AgreementV2[].class, ErrorV2Response.class, path);
    }

    public OrderV2 getOrder(String orderId) throws RestConnectorException {
        String path = "/order/" + orderId;
        log.debug("[getOrder] Por consultar order [{}] y path [{}]", (Object)orderId, (Object)path);
        return (OrderV2)this.restConnector.genericGet(null, OrderV2.class, ErrorV2Response.class, path);
    }

    public OrderV2Response postOrder(OrderV2Request orderRequest) throws RestConnectorException {
        String path = "/order";
        log.debug("[postOrder] Por crear order [{}]", (Object)orderRequest);
        return (OrderV2Response)this.restConnector.genericGet((Object)orderRequest, OrderV2Response.class, ErrorV2Response.class, "/order");
    }

    public FarmerV2 getFarmer(String farmerCuit) throws RestConnectorException {
        String path = "/farmers/" + farmerCuit;
        log.debug("[getFarmer] Por consultar farmer con cuit path [{}]", (Object)path);
        return (FarmerV2)this.restConnector.genericGet(null, FarmerV2.class, ErrorV2Response.class, path);
    }

    public FarmerV2 getFarmerMipyme(String partnerKeyName, String farmerCuit) throws RestConnectorException {
        String path = "/farmers/mipyme/" + partnerKeyName + "/" + farmerCuit;
        log.debug("[getFarmerMipyme] Por consultar farmer con cuit path [{}]", (Object)path);
        return (FarmerV2)this.restConnector.genericGet(null, FarmerV2.class, ErrorV2Response.class, path);
    }

    public EligibilityV2Response postEligibility(EligibilityV2Request eligibilityV2Request) throws RestConnectorException {
        String path = "/eligibility";
        log.debug("[postEligibility] Por hacer postEligibility para [{}]", (Object)eligibilityV2Request);
        return (EligibilityV2Response)this.restConnector.genericPost((Object)eligibilityV2Request, EligibilityV2Response.class, ErrorV2Response.class, "/eligibility");
    }

    public CreditCalculationV2Response postCreditCalculation(CreditCalculationV2Request creditCalculationV2Request) throws RestConnectorException {
        String path = "/credit-calculation";
        log.debug("[postCreditCalculation] Por hacer el calculo de creadito para [{}]", (Object)"/credit-calculation");
        return (CreditCalculationV2Response)this.restConnector.genericPost((Object)creditCalculationV2Request, CreditCalculationV2Response.class, ErrorV2Response.class, "/credit-calculation");
    }

    public String getMetrics() throws RestConnectorException {
        String path = "/metrics";
        log.debug("[getMetrics] Por consultar metricas con path [{}]", (Object)"/metrics");
        return (String)this.restConnector.genericGet(null, String.class, ErrorV2Response.class, "/metrics");
    }

    private String getAccessToken() throws RestConnectorException {
        return this.getToken(this.accessTokenCacheKey);
    }

    private String getRefreshToken() throws RestConnectorException {
        return this.getToken(this.refreshTokenCacheKey);
    }

    private String getIdToken() throws RestConnectorException {
        return this.getToken(this.idTokenCacheKey);
    }

    private String getToken(String cacheKey) throws RestConnectorException {
        String token = (String)this.cache.get(cacheKey);
        if (token == null) {
            this.login();
            token = (String)this.cache.get(cacheKey);
        }
        return token;
    }

    private void login() throws RestConnectorException {
        log.debug("[login] Por hacer login");
        this.doingLogin = true;
        TokenOAuth2Nera tokenOAuth2 = (TokenOAuth2Nera)this.restConnector.genericPost(Map.of("email", this.email, "password", this.password), TokenOAuth2Nera.class, ErrorV2Response.class, "/auth/login");
        this.doingLogin = false;
        String accessToken = tokenOAuth2.getAccessToken();
        String refreshToken = tokenOAuth2.getRefreshToken();
        String idToken = tokenOAuth2.getIdToken();
        Integer expiresIn = tokenOAuth2.getExpiresIn();
        log.debug("[login] Login realizado. Se guardan: accessToken [{}], refreshToken [{}] y idToken [{}] por [{}] segs", (Object)accessToken, (Object)refreshToken, (Object)idToken, (Object)expiresIn);
        this.cache.put(this.accessTokenCacheKey, (Object)accessToken, expiresIn);
        this.cache.put(this.refreshTokenCacheKey, (Object)refreshToken, expiresIn);
        this.cache.put(this.idTokenCacheKey, (Object)idToken, expiresIn);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null && !this.doingLogin) {
            builder.header("Authorization", (Object)("Bearer " + this.getAccessToken()));
            builder.header("id_token", (Object)this.getIdToken());
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public boolean retryOnUnauthorized() {
        if (this.doingLogin) {
            return false;
        }
        try {
            this.login();
            return true;
        }
        catch (RestConnectorException e) {
            return false;
        }
    }
}

