package ar.com.sdd.creditosimple.core.galicia;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.creditosimple.io.galicia.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.client.Invocation;
import java.util.HashMap;
import java.util.Map;

public class CreditoSimpleNeraV1Connector implements RestSecurityManager {

    private static final Logger log = LogManager.getLogger(CreditoSimpleNeraV1Connector.class);

    private final RestConnector restConnector;
    private final String appId;
    private final String appKey;

    public CreditoSimpleNeraV1Connector(CreditoSimpleNeraV1ConnectorContext context) {
        String baseUrl = context.getBaseUrl();
        appId = context.getAppId();
        appKey = context.getAppKey();

        log.debug("Creando conector para CreditoSimple Galicia con baseUrl [" + baseUrl + "], appId [" + appId + "], appKey [" + appKey + "]");

        RestConnectorEnvironment environment = new RestConnectorEnvironment(baseUrl, null, null, null, null);
        restConnector = new RestConnector(environment, this);

    }

    /**
     * Valida un cuit y devuelve solo 200 si esta bien
     * Si esta erroneo, devueve 500 y el ResponseError.class lleno
     *
     * @param cuit
     * @throws RestConnectorException
     */
    public void getValidarCuit(String cuit) throws RestConnectorException {
        getValidarCuit(cuit, "1");
    }
    public void getValidarCuit(String cuit, String productId) throws RestConnectorException {
        log.debug("[getValidarCuit] Request GET validar con cuit [" + cuit + "]");
        Map<String, Object> templateParameters = new HashMap<>();
        templateParameters.put("cuit", cuit);
        templateParameters.put("productId", productId);
        restConnector.genericGetTextResponse(null, ErrorV1Response.class, "/validar/{cuit}/{productId}", templateParameters);
        log.debug("[getValidarCuit] Response GET validar [OK]");
    }

    public ConveniosV1Response getConvenios()  throws RestConnectorException {
        return this.getConvenios(null,null,null);
    }
    public ConveniosV1Response getConvenios(String cuit, String segmentName, String productId)  throws RestConnectorException {
        log.debug("[getConvenios] Request GET convenios con cuit["+cuit+"]segment_name["+segmentName+"]productId["+productId+"]");
        String path = "/convenios";
        Map<String, Object> templateParameters = new HashMap<>();
        if (productId!=null && !productId.isEmpty()) {
            templateParameters.put("productId", productId);
            path +="/{productId}";
        }
        //Los queryParameters van distinto. Lo correcto seria que lo resuelva mejor el genericGet.....
        String sep="?";
        if (cuit!=null && !cuit.isEmpty()) {
            path += sep+"cuit="+cuit;
            sep="&";
        }
        if (segmentName!=null && !segmentName.isEmpty()) {
            path += sep+"segment_name="+segmentName;
            sep="&";
        }
        ConveniosV1Response response = restConnector.genericGet(null, ConveniosV1Response.class, ErrorV1Response.class, path, templateParameters);
        log.debug("[getConvenios] Response GET convenios [" + response + "]");
        return response;
    }

    public Simulacionv1Response postSimulacion(SimulacionV1Request simulacionRequest) throws RestConnectorException {
        log.debug("[postSimulacion] Request POST simulacion [" + simulacionRequest + "]");
        String path = "/simulacion";
        Simulacionv1Response response = restConnector.genericPost(simulacionRequest, Simulacionv1Response.class, ErrorV1Response.class, path);
        log.debug("[postSimulacion] Response POST simulacion [" + response + "]");
        return response;
    }

    public OrdenesV1Response postOrden(OrdenV1Request ordenRequest) throws RestConnectorException {
        log.debug("[postOrden] Request POST orden [" + ordenRequest + "]");
        String path = "/orders";
        OrdenesV1Response response = restConnector.genericPost(ordenRequest, OrdenesV1Response.class, ErrorV1Response.class, path);
        log.debug("[postOrden] Response POST orden [" + response + "]");
        return response;
    }

    public OrdenesV1Response getOrdenes() throws RestConnectorException {
        log.debug("[getOrdenes] Request GET ordenes sin parametros");
        String path = "/orders";
        OrdenesV1Response response = restConnector.genericGet(null, OrdenesV1Response.class, ErrorV1Response.class, path);
        log.debug("[getOrdenes] Response GET ordenes [" + response + "]");
        return response;
    }

    public OrdenesV1Response getOrden(String idOrden) throws RestConnectorException {
        log.debug("[getOrden] Request GET orden con idOrden [" + idOrden + "]");
        OrdenesV1Response response = restConnector.genericGet(null, OrdenesV1Response.class, ErrorV1Response.class, "/orders/{id_orden}", "id_orden", idOrden);
        log.debug("[getOrden] Response GET orden [" + response + "]");
        return response;
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder)  {
        builder.header("app_id", appId);
        builder.header("x-api-key", appKey);
        //Compat TGR:
        //En la version banco galicia, se necesita app_key, en la version Nera x-api-key
        //Inicalmente dejamos las dos , para que sean compatibles las conexiones y poder cambiar solo usanro unaa URL distinta
        //Una vez que este estable la migracio anera se puede borrar la app_key
        builder.header("app_key", appKey);
        return builder;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }

    @Override
    public boolean retryOnUnauthorized() {
        return false;
    }
}