package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreditDetails implements Serializable {

    @JsonProperty("cft_iva")
    private BigDecimal cftIva;
    
    @JsonProperty("amount")
    private BigDecimal amount;
    
    @JsonProperty("total_amount")
    private BigDecimal totalAmount;
    
    @JsonProperty("percentage_subsidy")
    private BigDecimal percentageSubsidy;
    
    @JsonProperty("tna")
    private BigDecimal tna;
    
    @JsonProperty("due_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd hh:mm:ss", timezone = "GMT-03:00")
    private Date dueDate;
    
    @JsonProperty("installment_quantity")
    private BigDecimal installmentQuantity;
    
    @JsonProperty("cft")
    private BigDecimal cft;
    
    @JsonProperty("associated_taxes")
    private BigDecimal associatedTaxes;
    
    @JsonProperty("tea")
    private BigDecimal tea;
    
    @JsonProperty("periodicity")
    private String periodicity;
    
    @JsonProperty("subsidy_amount")
    private BigDecimal subsidyAmount;
    
    @JsonProperty("currency")
    private String currency;
    
    @JsonProperty("tem")
    private BigDecimal tem;
    
    @JsonProperty("total_interest_nominal")
    private BigDecimal totalInterestNominal;
    
    @JsonProperty("total_vat_interest")
    private BigDecimal totalVatInterest;
    
    @JsonProperty("total_ivap_interest_nominal")
    private BigDecimal totalIvapInterestNominal;
    
    @JsonProperty("total_stamp_taxes")
    private BigDecimal totalStampTaxes;
    
    @JsonProperty("tna_base")
    private BigDecimal tnaBase;
    
    @JsonProperty("capital_cost")
    private BigDecimal capitalCost;
    
    @JsonProperty("installments")
    private List<Installment> installments;

    public BigDecimal getCftIva() {
        return cftIva;
    }

    public void setCftIva(BigDecimal cftIva) {
        this.cftIva = cftIva;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getPercentageSubsidy() {
        return percentageSubsidy;
    }

    public void setPercentageSubsidy(BigDecimal percentageSubsidy) {
        this.percentageSubsidy = percentageSubsidy;
    }

    public BigDecimal getTna() {
        return tna;
    }

    public void setTna(BigDecimal tna) {
        this.tna = tna;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public BigDecimal getInstallmentQuantity() {
        return installmentQuantity;
    }

    public void setInstallmentQuantity(BigDecimal installmentQuantity) {
        this.installmentQuantity = installmentQuantity;
    }

    public BigDecimal getCft() {
        return cft;
    }

    public void setCft(BigDecimal cft) {
        this.cft = cft;
    }

    public BigDecimal getAssociatedTaxes() {
        return associatedTaxes;
    }

    public void setAssociatedTaxes(BigDecimal associatedTaxes) {
        this.associatedTaxes = associatedTaxes;
    }

    public BigDecimal getTea() {
        return tea;
    }

    public void setTea(BigDecimal tea) {
        this.tea = tea;
    }

    public String getPeriodicity() {
        return periodicity;
    }

    public void setPeriodicity(String periodicity) {
        this.periodicity = periodicity;
    }

    public BigDecimal getSubsidyAmount() {
        return subsidyAmount;
    }

    public void setSubsidyAmount(BigDecimal subsidyAmount) {
        this.subsidyAmount = subsidyAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getTem() {
        return tem;
    }

    public void setTem(BigDecimal tem) {
        this.tem = tem;
    }

    public BigDecimal getTotalInterestNominal() {
        return totalInterestNominal;
    }

    public void setTotalInterestNominal(BigDecimal totalInterestNominal) {
        this.totalInterestNominal = totalInterestNominal;
    }

    public BigDecimal getTotalVatInterest() {
        return totalVatInterest;
    }

    public void setTotalVatInterest(BigDecimal totalVatInterest) {
        this.totalVatInterest = totalVatInterest;
    }

    public BigDecimal getTotalIvapInterestNominal() {
        return totalIvapInterestNominal;
    }

    public void setTotalIvapInterestNominal(BigDecimal totalIvapInterestNominal) {
        this.totalIvapInterestNominal = totalIvapInterestNominal;
    }

    public BigDecimal getTotalStampTaxes() {
        return totalStampTaxes;
    }

    public void setTotalStampTaxes(BigDecimal totalStampTaxes) {
        this.totalStampTaxes = totalStampTaxes;
    }

    public BigDecimal getTnaBase() {
        return tnaBase;
    }

    public void setTnaBase(BigDecimal tnaBase) {
        this.tnaBase = tnaBase;
    }

    public BigDecimal getCapitalCost() {
        return capitalCost;
    }

    public void setCapitalCost(BigDecimal capitalCost) {
        this.capitalCost = capitalCost;
    }

    public List<Installment> getInstallments() {
        return installments;
    }

    public void setInstallments(List<Installment> installments) {
        this.installments = installments;
    }

    @Override
    public String toString() {
        return "CreditDetails [" +
                ((cftIva != null) ? "cftIva=" + cftIva + ", " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "") +
                ((percentageSubsidy != null) ? "percentageSubsidy=" + percentageSubsidy + ", " : "") +
                ((tna != null) ? "tna=" + tna + ", " : "") +
                ((dueDate != null) ? "dueDate='" + dueDate + "', " : "") +
                ((installmentQuantity != null) ? "installmentQuantity=" + installmentQuantity + ", " : "") +
                ((cft != null) ? "cft=" + cft + ", " : "") +
                ((associatedTaxes != null) ? "associatedTaxes=" + associatedTaxes + ", " : "") +
                ((tea != null) ? "tea=" + tea + ", " : "") +
                ((periodicity != null) ? "periodicity='" + periodicity + "', " : "") +
                ((subsidyAmount != null) ? "subsidyAmount=" + subsidyAmount + ", " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((tem != null) ? "tem=" + tem + ", " : "") +
                ((totalInterestNominal != null) ? "totalInterestNominal=" + totalInterestNominal + ", " : "") +
                ((totalVatInterest != null) ? "totalVatInterest=" + totalVatInterest + ", " : "") +
                ((totalIvapInterestNominal != null) ? "totalIvapInterestNominal=" + totalIvapInterestNominal + ", " : "") +
                ((totalStampTaxes != null) ? "totalStampTaxes=" + totalStampTaxes + ", " : "") +
                ((tnaBase != null) ? "tnaBase=" + tnaBase + ", " : "") +
                ((capitalCost != null) ? "capitalCost=" + capitalCost + ", " : "") +
                ((installments != null) ? "installments=" + Arrays.toString(installments.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CreditDetails that = (CreditDetails) o;
        return Objects.equals(cftIva, that.cftIva) && Objects.equals(amount, that.amount) && Objects.equals(totalAmount, that.totalAmount) && Objects.equals(percentageSubsidy, that.percentageSubsidy) && Objects.equals(tna, that.tna) && Objects.equals(dueDate, that.dueDate) && Objects.equals(installmentQuantity, that.installmentQuantity) && Objects.equals(cft, that.cft) && Objects.equals(associatedTaxes, that.associatedTaxes) && Objects.equals(tea, that.tea) && Objects.equals(periodicity, that.periodicity) && Objects.equals(subsidyAmount, that.subsidyAmount) && Objects.equals(currency, that.currency) && Objects.equals(tem, that.tem) && Objects.equals(totalInterestNominal, that.totalInterestNominal) && Objects.equals(totalVatInterest, that.totalVatInterest) && Objects.equals(totalIvapInterestNominal, that.totalIvapInterestNominal) && Objects.equals(totalStampTaxes, that.totalStampTaxes) && Objects.equals(tnaBase, that.tnaBase) && Objects.equals(capitalCost, that.capitalCost) && Objects.equals(installments, that.installments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cftIva, amount, totalAmount, percentageSubsidy, tna, dueDate, installmentQuantity, cft, associatedTaxes, tea, periodicity, subsidyAmount, currency, tem, totalInterestNominal, totalVatInterest, totalIvapInterestNominal, totalStampTaxes, tnaBase, capitalCost, installments);
    }
}