package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Installment implements Serializable {

    @JsonProperty("number")
    private Integer number;

    @JsonProperty("amount")
    private BigDecimal amount;

    @JsonProperty("due_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "GMT-03:00")
    private Date dueDate;

    @JsonProperty("stamp_taxes")
    private BigDecimal stampTaxes;

    @JsonProperty("vat_interest")
    private BigDecimal vatInterest;

    @JsonProperty("interest_nominal")
    private BigDecimal interestNominal;

    @JsonProperty("total_vat_interest")
    private BigDecimal totalVatInterest;

    @JsonProperty("amortization")
    private BigDecimal amortization;

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public BigDecimal getStampTaxes() {
        return stampTaxes;
    }

    public void setStampTaxes(BigDecimal stampTaxes) {
        this.stampTaxes = stampTaxes;
    }

    public BigDecimal getVatInterest() {
        return vatInterest;
    }

    public void setVatInterest(BigDecimal vatInterest) {
        this.vatInterest = vatInterest;
    }

    public BigDecimal getInterestNominal() {
        return interestNominal;
    }

    public void setInterestNominal(BigDecimal interestNominal) {
        this.interestNominal = interestNominal;
    }

    public BigDecimal getTotalVatInterest() {
        return totalVatInterest;
    }

    public void setTotalVatInterest(BigDecimal totalVatInterest) {
        this.totalVatInterest = totalVatInterest;
    }

    public BigDecimal getAmortization() {
        return amortization;
    }

    public void setAmortization(BigDecimal amortization) {
        this.amortization = amortization;
    }

    @Override
    public String toString() {
        return "Installment [" +
                ((number != null) ? "number=" + number + ", " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((dueDate != null) ? "dueDate=" + dueDate + ", " : "") +
                ((stampTaxes != null) ? "stampTaxes=" + stampTaxes + ", " : "") +
                ((vatInterest != null) ? "vatInterest=" + vatInterest + ", " : "") +
                ((interestNominal != null) ? "interestNominal=" + interestNominal + ", " : "") +
                ((totalVatInterest != null) ? "totalVatInterest=" + totalVatInterest + ", " : "") +
                ((amortization != null) ? "amortization=" + amortization + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Installment that = (Installment) o;
        return Objects.equals(number, that.number) && Objects.equals(amount, that.amount) && Objects.equals(dueDate, that.dueDate) && Objects.equals(stampTaxes, that.stampTaxes) && Objects.equals(vatInterest, that.vatInterest) && Objects.equals(interestNominal, that.interestNominal) && Objects.equals(totalVatInterest, that.totalVatInterest) && Objects.equals(amortization, that.amortization);
    }

    @Override
    public int hashCode() {
        return Objects.hash(number, amount, dueDate, stampTaxes, vatInterest, interestNominal, totalVatInterest, amortization);
    }
}