package ar.com.sdd.creditosimple.entity.galicia;

import ar.com.sdd.commons.rest.model.TokenOAuth2;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TokenOAuth2Nera extends TokenOAuth2 implements Serializable {

    @JsonProperty("id_token")
    private String idToken = null;

    public String getIdToken() {
        return idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    @Override
    public String toString() {
        return "TokenOAuth2Nera [" +
                ((getAccessToken() != null) ? "accessToken='" + getAccessToken() + "', " : "") +
                ((getTokenType() != null) ? "tokenType='" + getTokenType() + "', " : "") +
                ((getExpiresIn() != null) ? "expiresIn=" + getExpiresIn() + ", " : "") +
                ((getRefreshExpiresIn() != null) ? "refreshExpiresIn=" + getRefreshExpiresIn() + ", " : "") +
                ((getRefreshToken() != null) ? "refreshToken='" + getRefreshToken() + "', " : "") +
                ((getNotBeforePolicy() != null) ? "notBeforePolicy=" + getNotBeforePolicy() + ", " : "") +
                ((getSessionState() != null) ? "sessionState='" + getSessionState() + "', " : "") +
                ((getScope() != null) ? "scope='" + getScope() + "', " : "") +
                ((idToken != null) ? "idToken='" + idToken + "'" : "") +
                "]";
    }
}