package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class FarmerV2 implements Serializable {

    @JsonProperty("name")
    private String name;

    @JsonProperty("document_number")
    private String documentNumber;

    @JsonProperty("document_type")
    private String documentType;

    @JsonProperty("is_mipyme")
    private Boolean isMipyme;

    @JsonProperty("users")
    private List<User> users;

    @JsonProperty("segments")
    private Segment segments;

    @JsonProperty("address")
    private AddressV2 address;

    @JsonProperty("commercial_activities")
    private List<Integer> commercialActivities;

    @JsonProperty("cuit")
    private String cuit;

    @JsonProperty("email")
    private String email;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public Boolean getMipyme() {
        return isMipyme;
    }

    public void setMipyme(Boolean mipyme) {
        isMipyme = mipyme;
    }

    public List<User> getUsers() {
        return users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public Segment getSegments() {
        return segments;
    }

    public void setSegments(Segment segments) {
        this.segments = segments;
    }

    public AddressV2 getAddress() {
        return address;
    }

    public void setAddress(AddressV2 address) {
        this.address = address;
    }

    public List<Integer> getCommercialActivities() {
        return commercialActivities;
    }

    public void setCommercialActivities(List<Integer> commercialActivities) {
        this.commercialActivities = commercialActivities;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String toString() {
        return "FarmerV2 [" +
                ((name != null) ? "name='" + name + "', " : "") +
                ((documentNumber != null) ? "documentNumber='" + documentNumber + "', " : "") +
                ((documentType != null) ? "documentType='" + documentType + "', " : "") +
                ((isMipyme != null) ? "isMipyme=" + isMipyme + ", " : "") +
                ((users != null) ? "users=" + Arrays.toString(users.toArray()) + ", " : "") +
                ((segments != null) ? "segments=" + segments + ", " : "") +
                ((address != null) ? "address=" + address + ", " : "") +
                ((commercialActivities != null) ? "commercialActivities=" + Arrays.toString(commercialActivities.toArray()) + ", " : "") +
                ((cuit != null) ? "cuit='" + cuit + "', " : "") +
                ((email != null) ? "email='" + email + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FarmerV2 farmerV2 = (FarmerV2) o;
        return Objects.equals(name, farmerV2.name) && Objects.equals(documentNumber, farmerV2.documentNumber) && Objects.equals(documentType, farmerV2.documentType) && Objects.equals(isMipyme, farmerV2.isMipyme) && Objects.equals(users, farmerV2.users) && Objects.equals(segments, farmerV2.segments) && Objects.equals(address, farmerV2.address) && Objects.equals(commercialActivities, farmerV2.commercialActivities) && Objects.equals(cuit, farmerV2.cuit) && Objects.equals(email, farmerV2.email);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, documentNumber, documentType, isMipyme, users, segments, address, commercialActivities, cuit, email);
    }
}