package ar.com.sdd.creditosimple.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CuotaV1 {

    private Integer numero;

    @JsonProperty("fecha_vencimiento")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy", timezone = "GMT-03:00")
    private Date fechaVencimiento;

    private BigDecimal monto;

    public Integer getNumero() {
        return numero;
    }

    public void setNumero(Integer numero) {
        this.numero = numero;
    }

    public Date getFechaVencimiento() {
        return fechaVencimiento;
    }

    public void setFechaVencimiento(Date fechaVencimiento) {
        this.fechaVencimiento = fechaVencimiento;
    }

    public BigDecimal getMonto() {
        return monto;
    }

    public void setMonto(BigDecimal monto) {
        this.monto = monto;
    }

    @Override
    public String toString() {
        return "Cuota ["
                + ((numero != null) ? "numero=" + numero + ", " : "")
                + ((fechaVencimiento != null) ? "fechaVencimiento=" + fechaVencimiento + ", " : "")
                + ((monto != null) ? "monto=" + monto : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CuotaV1 cuota = (CuotaV1) o;

        if (numero != null ? !numero.equals(cuota.numero) : cuota.numero != null) return false;
        if (fechaVencimiento != null ? !fechaVencimiento.equals(cuota.fechaVencimiento) : cuota.fechaVencimiento != null) return false;
        return monto != null ? monto.equals(cuota.monto) : cuota.monto == null;
    }

    @Override
    public int hashCode() {
        int result = numero != null ? numero.hashCode() : 0;
        result = 31 * result + (fechaVencimiento != null ? fechaVencimiento.hashCode() : 0);
        result = 31 * result + (monto != null ? monto.hashCode() : 0);
        return result;
    }
}

