package ar.com.sdd.creditosimple.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName("informacion_financiera")
public class InformacionFinancieraV1 {
    /* Sample:
    {
        "costo_financiero_total": 106.549335,
        "costo_financiero_total_sin_impuestos": 96.461615,
        "interes_efectivo_mensual": 5.723018,
        "interes_efectivo_anual": 95.0,
        "interes_nominal_anual": 95.0,
        "monto_prestamo": 270.62,
        "numero_cuotas": 12
    },*/

    @JsonProperty("costo_financiero_total")
    private BigDecimal costoFinancieroTotal;

    @JsonProperty("costo_financiero_total_sin_impuestos")
    private BigDecimal costoFinancieroSinImpuestos;

    @JsonProperty("interes_efectivo_mensual")
    private BigDecimal interesEfectivoMensual;

    @JsonProperty("interes_efectivo_anual")
    private BigDecimal interesEfectivoAnual;

    @JsonProperty("interes_nominal_anual")
    private BigDecimal interesNominalAnual;

    @JsonProperty("monto_prestamo")
    private BigDecimal montoPrestamo;

    @JsonProperty("numero_cuotas")
    private Integer numeroCuotas;

    public BigDecimal getCostoFinancieroTotal() {
        return costoFinancieroTotal;
    }

    public void setCostoFinancieroTotal(BigDecimal costoFinancieroTotal) {
        this.costoFinancieroTotal = costoFinancieroTotal;
    }

    public BigDecimal getCostoFinancieroSinImpuestos() {
        return costoFinancieroSinImpuestos;
    }

    public void setCostoFinancieroSinImpuestos(BigDecimal costoFinancieroSinImpuestos) {
        this.costoFinancieroSinImpuestos = costoFinancieroSinImpuestos;
    }

    public BigDecimal getInteresEfectivoMensual() {
        return interesEfectivoMensual;
    }

    public void setInteresEfectivoMensual(BigDecimal interesEfectivoMensual) {
        this.interesEfectivoMensual = interesEfectivoMensual;
    }

    public BigDecimal getInteresEfectivoAnual() {
        return interesEfectivoAnual;
    }

    public void setInteresEfectivoAnual(BigDecimal interesEfectivoAnual) {
        this.interesEfectivoAnual = interesEfectivoAnual;
    }

    public BigDecimal getInteresNominalAnual() {
        return interesNominalAnual;
    }

    public void setInteresNominalAnual(BigDecimal interesNominalAnual) {
        this.interesNominalAnual = interesNominalAnual;
    }

    public BigDecimal getMontoPrestamo() {
        return montoPrestamo;
    }

    public void setMontoPrestamo(BigDecimal montoPrestamo) {
        this.montoPrestamo = montoPrestamo;
    }

    public Integer getNumeroCuotas() {
        return numeroCuotas;
    }

    public void setNumeroCuotas(Integer numeroCuotas) {
        this.numeroCuotas = numeroCuotas;
    }

    @Override
    public String toString() {
        return "InformacionFinanciera ["
                + ((costoFinancieroTotal != null) ? "costoFinancieroTotal=" + costoFinancieroTotal + ", " : "")
                + ((costoFinancieroSinImpuestos != null) ? "costoFinancieroSinImpuestos=" + costoFinancieroSinImpuestos + ", " : "")
                + ((interesEfectivoMensual != null) ? "interesEfectivoMensual=" + interesEfectivoMensual + ", " : "")
                + ((interesEfectivoAnual != null) ? "interesEfectivoAnual=" + interesEfectivoAnual + ", " : "")
                + ((interesNominalAnual != null) ? "interesNominalAnual=" + interesNominalAnual + ", " : "")
                + ((montoPrestamo != null) ? "montoPrestamo=" + montoPrestamo + ", " : "")
                + ((numeroCuotas != null) ? "numeroCuotas=" + numeroCuotas : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        InformacionFinancieraV1 that = (InformacionFinancieraV1) o;

        if (costoFinancieroTotal != null ? !costoFinancieroTotal.equals(that.costoFinancieroTotal) : that.costoFinancieroTotal != null) return false;
        if (costoFinancieroSinImpuestos != null ? !costoFinancieroSinImpuestos.equals(that.costoFinancieroSinImpuestos) : that.costoFinancieroSinImpuestos != null) return false;
        if (interesEfectivoMensual != null ? !interesEfectivoMensual.equals(that.interesEfectivoMensual) : that.interesEfectivoMensual != null) return false;
        if (interesEfectivoAnual != null ? !interesEfectivoAnual.equals(that.interesEfectivoAnual) : that.interesEfectivoAnual != null) return false;
        if (interesNominalAnual != null ? !interesNominalAnual.equals(that.interesNominalAnual) : that.interesNominalAnual != null) return false;
        if (montoPrestamo != null ? !montoPrestamo.equals(that.montoPrestamo) : that.montoPrestamo != null) return false;
        return numeroCuotas != null ? numeroCuotas.equals(that.numeroCuotas) : that.numeroCuotas == null;
    }

    @Override
    public int hashCode() {
        int result = costoFinancieroTotal != null ? costoFinancieroTotal.hashCode() : 0;
        result = 31 * result + (costoFinancieroSinImpuestos != null ? costoFinancieroSinImpuestos.hashCode() : 0);
        result = 31 * result + (interesEfectivoMensual != null ? interesEfectivoMensual.hashCode() : 0);
        result = 31 * result + (interesEfectivoAnual != null ? interesEfectivoAnual.hashCode() : 0);
        result = 31 * result + (interesNominalAnual != null ? interesNominalAnual.hashCode() : 0);
        result = 31 * result + (montoPrestamo != null ? montoPrestamo.hashCode() : 0);
        result = 31 * result + (numeroCuotas != null ? numeroCuotas.hashCode() : 0);
        return result;
    }
}

