package ar.com.sdd.creditosimple.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OrdenV1 {

    @JsonProperty("id_orden")
    private String idOrden;

    @JsonProperty("id_orden_entidad_financiera")
    private String idOrdenEntidadFinanciera;

    private String estado;

    @JsonProperty("descripcion_estado")
    private String descripcionEstado;

    private String cuit;

    @JsonProperty("razon_social")
    private String razonSocial;

    private BigDecimal monto;

    @JsonProperty("id_empresa")
    private String idEmpresa;

    public String getIdOrden() {
        return idOrden;
    }

    public void setIdOrden(String idOrden) {
        this.idOrden = idOrden;
    }

    public String getIdOrdenEntidadFinanciera() {return idOrdenEntidadFinanciera;}

    public void setIdOrdenEntidadFinanciera(String idOrdenEntidadFinanciera) {this.idOrdenEntidadFinanciera = idOrdenEntidadFinanciera;}

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public String getDescripcionEstado() {
        return descripcionEstado;
    }

    public void setDescripcionEstado(String descripcionEstado) {
        this.descripcionEstado = descripcionEstado;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getRazonSocial() {
        return razonSocial;
    }

    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    public BigDecimal getMonto() {
        return monto;
    }

    public void setMonto(BigDecimal monto) {
        this.monto = monto;
    }

    public String getIdEmpresa() {
        return idEmpresa;
    }

    public void setIdEmpresa(String idEmpresa) {
        this.idEmpresa = idEmpresa;
    }

    @Override
    public String toString() {
        return "Orden ["
                + ((idOrden != null) ? "idOrden=" + idOrden + ", " : "")
                + ((idOrdenEntidadFinanciera != null) ? "idOrdenEntidadFinanciera=" + idOrdenEntidadFinanciera + ", " : "")
                + ((estado != null) ? "estado=" + estado + ", " : "")
                + ((descripcionEstado != null) ? "descripcionEstado=" + descripcionEstado + ", " : "")
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((razonSocial != null) ? "razonSocial=" + razonSocial + ", " : "")
                + ((monto != null) ? "monto=" + monto + ", " : "")
                + ((idEmpresa != null) ? "idEmpresa=" + idEmpresa : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OrdenV1 orden = (OrdenV1) o;

        if (idOrden != null ? !idOrden.equals(orden.idOrden) : orden.idOrden != null) return false;
        if (idOrdenEntidadFinanciera != null ? !idOrdenEntidadFinanciera.equals(orden.idOrdenEntidadFinanciera) : orden.idOrdenEntidadFinanciera != null) return false;
        if (estado != null ? !estado.equals(orden.estado) : orden.estado != null) return false;
        if (descripcionEstado != null ? !descripcionEstado.equals(orden.descripcionEstado) : orden.descripcionEstado != null) return false;
        if (cuit != null ? !cuit.equals(orden.cuit) : orden.cuit != null) return false;
        if (razonSocial != null ? !razonSocial.equals(orden.razonSocial) : orden.razonSocial != null) return false;
        if (monto != null ? !monto.equals(orden.monto) : orden.monto != null) return false;
        return idEmpresa != null ? idEmpresa.equals(orden.idEmpresa) : orden.idEmpresa == null;
    }

    @Override
    public int hashCode() {
        int result = idOrden != null ? idOrden.hashCode() : 0;
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        result = 31 * result + (descripcionEstado != null ? descripcionEstado.hashCode() : 0);
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        result = 31 * result + (razonSocial != null ? razonSocial.hashCode() : 0);
        result = 31 * result + (monto != null ? monto.hashCode() : 0);
        result = 31 * result + (idEmpresa != null ? idEmpresa.hashCode() : 0);
        return result;
    }
}

