package ar.com.sdd.creditosimple.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AgreementV2 implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("installments")
    private Integer installments;

    @JsonProperty("tna_farmer")
    private BigDecimal tnaFarmer;
    
    @JsonProperty("interest_period_months")
    private Integer interestPeriodMonths;
    
    @JsonProperty("subsidy")
    private BigDecimal subsidy;

    @JsonProperty("first_expiration_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date firstExpirationDate;

    @JsonProperty("first_interest_expiration_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "GMT-03:00")
    private Date firstInterestExpirationDate;

    @JsonProperty("description")
    private String description;
    
    @JsonProperty("loan_to_value_ratio")
    private BigDecimal loanToValueRatio;
    
    @JsonProperty("quantity_of_quotas")
    private Integer quantityOfQuotas;
    
    @JsonProperty("capital_period_months")
    private Integer capitalPeriodMonths;
    
    @JsonProperty("loan_type")
    private String loanType;
    
    @JsonProperty("periodicity")
    private String periodicity;
    
    @JsonProperty("fee")
    private BigDecimal fee;

    @JsonProperty("tna_base")
    private BigDecimal tnaBase;

    @JsonProperty("tna_mipyme")
    private BigDecimal tnaMipyme;

    @JsonProperty("tna_merchant")
    private BigDecimal tnaMerchant;

    @JsonProperty("financing_type")
    private String financingType;

    @JsonProperty("merchant_id")
    private Long merchantId;

    @JsonProperty("product_id")
    private String productId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getInstallments() {
        return installments;
    }

    public void setInstallments(Integer installments) {
        this.installments = installments;
    }

    public BigDecimal getTnaFarmer() {
        return tnaFarmer;
    }

    public void setTnaFarmer(BigDecimal tnaFarmer) {
        this.tnaFarmer = tnaFarmer;
    }

    public Integer getInterestPeriodMonths() {
        return interestPeriodMonths;
    }

    public void setInterestPeriodMonths(Integer interestPeriodMonths) {
        this.interestPeriodMonths = interestPeriodMonths;
    }

    public BigDecimal getSubsidy() {
        return subsidy;
    }

    public void setSubsidy(BigDecimal subsidy) {
        this.subsidy = subsidy;
    }

    public Date getFirstExpirationDate() {
        return firstExpirationDate;
    }

    public void setFirstExpirationDate(Date firstExpirationDate) {
        this.firstExpirationDate = firstExpirationDate;
    }

    public Date getFirstInterestExpirationDate() {
        return firstInterestExpirationDate;
    }

    public void setFirstInterestExpirationDate(Date firstInterestExpirationDate) {
        this.firstInterestExpirationDate = firstInterestExpirationDate;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getLoanToValueRatio() {
        return loanToValueRatio;
    }

    public void setLoanToValueRatio(BigDecimal loanToValueRatio) {
        this.loanToValueRatio = loanToValueRatio;
    }

    public Integer getQuantityOfQuotas() {
        return quantityOfQuotas;
    }

    public void setQuantityOfQuotas(Integer quantityOfQuotas) {
        this.quantityOfQuotas = quantityOfQuotas;
    }

    public Integer getCapitalPeriodMonths() {
        return capitalPeriodMonths;
    }

    public void setCapitalPeriodMonths(Integer capitalPeriodMonths) {
        this.capitalPeriodMonths = capitalPeriodMonths;
    }

    public String getLoanType() {
        return loanType;
    }

    public void setLoanType(String loanType) {
        this.loanType = loanType;
    }

    public String getPeriodicity() {
        return periodicity;
    }

    public void setPeriodicity(String periodicity) {
        this.periodicity = periodicity;
    }

    public BigDecimal getFee() {
        return fee;
    }

    public void setFee(BigDecimal fee) {
        this.fee = fee;
    }

    public BigDecimal getTnaBase() {
        return tnaBase;
    }

    public void setTnaBase(BigDecimal tnaBase) {
        this.tnaBase = tnaBase;
    }

    public BigDecimal getTnaMipyme() {
        return tnaMipyme;
    }

    public void setTnaMipyme(BigDecimal tnaMipyme) {
        this.tnaMipyme = tnaMipyme;
    }

    public BigDecimal getTnaMerchant() {
        return tnaMerchant;
    }

    public void setTnaMerchant(BigDecimal tnaMerchant) {
        this.tnaMerchant = tnaMerchant;
    }

    public String getFinancingType() {
        return financingType;
    }

    public void setFinancingType(String financingType) {
        this.financingType = financingType;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    @Override
    public String toString() {
        return "AgreementV2 [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((installments != null) ? "installments=" + installments + ", " : "") +
                ((tnaFarmer != null) ? "tnaFarmer=" + tnaFarmer + ", " : "") +
                ((interestPeriodMonths != null) ? "interestPeriodMonths=" + interestPeriodMonths + ", " : "") +
                ((subsidy != null) ? "subsidy=" + subsidy + ", " : "") +
                ((firstExpirationDate != null) ? "firstExpirationDate=" + firstExpirationDate + ", " : "") +
                ((firstInterestExpirationDate != null) ? "firstInterestExpirationDate=" + firstInterestExpirationDate + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((loanToValueRatio != null) ? "loanToValueRatio=" + loanToValueRatio + ", " : "") +
                ((quantityOfQuotas != null) ? "quantityOfQuotas=" + quantityOfQuotas + ", " : "") +
                ((capitalPeriodMonths != null) ? "capitalPeriodMonths=" + capitalPeriodMonths + ", " : "") +
                ((loanType != null) ? "loanType='" + loanType + "', " : "") +
                ((periodicity != null) ? "periodicity='" + periodicity + "', " : "") +
                ((fee != null) ? "fee=" + fee + ", " : "") +
                ((tnaBase != null) ? "tnaBase=" + tnaBase + ", " : "") +
                ((tnaMipyme != null) ? "tnaMipyme=" + tnaMipyme + ", " : "") +
                ((tnaMerchant != null) ? "tnaMerchant=" + tnaMerchant + ", " : "") +
                ((financingType != null) ? "financingType='" + financingType + "', " : "") +
                ((merchantId != null) ? "merchantId=" + merchantId + ", " : "") +
                ((productId != null) ? "productId='" + productId + "'" : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AgreementV2 that = (AgreementV2) o;
        return Objects.equals(id, that.id) && Objects.equals(installments, that.installments) && Objects.equals(tnaFarmer, that.tnaFarmer) && Objects.equals(interestPeriodMonths, that.interestPeriodMonths) && Objects.equals(subsidy, that.subsidy) && Objects.equals(firstExpirationDate, that.firstExpirationDate) && Objects.equals(firstInterestExpirationDate, that.firstInterestExpirationDate) && Objects.equals(description, that.description) && Objects.equals(loanToValueRatio, that.loanToValueRatio) && Objects.equals(quantityOfQuotas, that.quantityOfQuotas) && Objects.equals(capitalPeriodMonths, that.capitalPeriodMonths) && Objects.equals(loanType, that.loanType) && Objects.equals(periodicity, that.periodicity) && Objects.equals(fee, that.fee) && Objects.equals(tnaBase, that.tnaBase) && Objects.equals(tnaMipyme, that.tnaMipyme) && Objects.equals(tnaMerchant, that.tnaMerchant) && Objects.equals(financingType, that.financingType) && Objects.equals(merchantId, that.merchantId) && Objects.equals(productId, that.productId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, installments, tnaFarmer, interestPeriodMonths, subsidy, firstExpirationDate, firstInterestExpirationDate, description, loanToValueRatio, quantityOfQuotas, capitalPeriodMonths, loanType, periodicity, fee, tnaBase, tnaMipyme, tnaMerchant, financingType, merchantId, productId);
    }
}