package ar.com.sdd.creditosimple.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class OrderV2 implements Serializable {

    @JsonProperty("order_id")
    private String orderId;

    @JsonProperty("status")
    private String status;

    @JsonProperty("status_description")
    private String statusDescription;

    @JsonProperty("farmer")
    private FarmerV2 farmer;

    @JsonProperty("amount")
    private BigDecimal amount;

    @JsonProperty("order_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "GMT-03:00")
    private Date orderDate;

    @JsonProperty("create_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "GMT-03:00")
    private Date createDate;

    @JsonProperty("expiry_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "GMT-03:00")
    private Date expiryDate;

    @JsonProperty("payment_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "GMT-03:00")
    private Date paymentDate;

    @JsonProperty("due_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "GMT-03:00")
    private Date dueDate;

    @JsonProperty("currency_code")
    private String currencyCode;

    @JsonProperty("currency_name")
    private String currencyName;

    @JsonProperty("exchange_rate")
    private BigDecimal exchangeRate;

    @JsonProperty("installment_quantity")
    private Integer installmentQuantity;

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusDescription() {
        return statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public FarmerV2 getFarmer() {
        return farmer;
    }

    public void setFarmer(FarmerV2 farmer) {
        this.farmer = farmer;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Date getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Date getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getCurrencyName() {
        return currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public Integer getInstallmentQuantity() {
        return installmentQuantity;
    }

    public void setInstallmentQuantity(Integer installmentQuantity) {
        this.installmentQuantity = installmentQuantity;
    }

    @Override
    public String toString() {
        return "OrderV2 [" +
                ((orderId != null) ? "orderId='" + orderId + "', " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((statusDescription != null) ? "statusDescription='" + statusDescription + "', " : "") +
                ((farmer != null) ? "farmer=" + farmer + ", " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((orderDate != null) ? "orderDate=" + orderDate + ", " : "") +
                ((createDate != null) ? "createDate=" + createDate + ", " : "") +
                ((expiryDate != null) ? "expiryDate=" + expiryDate + ", " : "") +
                ((paymentDate != null) ? "paymentDate=" + paymentDate + ", " : "") +
                ((dueDate != null) ? "dueDate=" + dueDate + ", " : "") +
                ((currencyCode != null) ? "currencyCode='" + currencyCode + "', " : "") +
                ((currencyName != null) ? "currencyName='" + currencyName + "', " : "") +
                ((exchangeRate != null) ? "exchangeRate=" + exchangeRate + ", " : "") +
                ((installmentQuantity != null) ? "installmentQuantity=" + installmentQuantity + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrderV2 orderV2 = (OrderV2) o;
        return Objects.equals(orderId, orderV2.orderId) && Objects.equals(status, orderV2.status) && Objects.equals(statusDescription, orderV2.statusDescription) && Objects.equals(farmer, orderV2.farmer) && Objects.equals(amount, orderV2.amount) && Objects.equals(orderDate, orderV2.orderDate) && Objects.equals(createDate, orderV2.createDate) && Objects.equals(expiryDate, orderV2.expiryDate) && Objects.equals(paymentDate, orderV2.paymentDate) && Objects.equals(dueDate, orderV2.dueDate) && Objects.equals(currencyCode, orderV2.currencyCode) && Objects.equals(currencyName, orderV2.currencyName) && Objects.equals(exchangeRate, orderV2.exchangeRate) && Objects.equals(installmentQuantity, orderV2.installmentQuantity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderId, status, statusDescription, farmer, amount, orderDate, createDate, expiryDate, paymentDate, dueDate, currencyCode, currencyName, exchangeRate, installmentQuantity);
    }
}