package ar.com.sdd.creditosimple.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class User implements Serializable {

    @JsonProperty("auth0_id")
    private String authId;

    @JsonProperty("email")
    private String email;

    @JsonProperty("cuil")
    private String cuil;

    @JsonProperty("name")
    private String name;

    @JsonProperty("last_name")
    private String lastName;

    @JsonProperty("partners")
    private List<PartnerV2> partners;

    public String getAuthId() {
        return authId;
    }

    public void setAuthId(String authId) {
        this.authId = authId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCuil() {
        return cuil;
    }

    public void setCuil(String cuil) {
        this.cuil = cuil;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public List<PartnerV2> getPartners() {
        return partners;
    }

    public void setPartners(List<PartnerV2> partners) {
        this.partners = partners;
    }

    @Override
    public String toString() {
        return "User [" +
                ((authId != null) ? "authId='" + authId + "', " : "") +
                ((email != null) ? "email='" + email + "', " : "") +
                ((cuil != null) ? "cuil='" + cuil + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((lastName != null) ? "lastName='" + lastName + "', " : "") +
                ((partners != null) ? "partners=" + Arrays.toString(partners.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        User user = (User) o;
        return Objects.equals(authId, user.authId) && Objects.equals(email, user.email) && Objects.equals(cuil, user.cuil) && Objects.equals(name, user.name) && Objects.equals(lastName, user.lastName) && Objects.equals(partners, user.partners);
    }

    @Override
    public int hashCode() {
        return Objects.hash(authId, email, cuil, name, lastName, partners);
    }
}