package ar.com.sdd.creditosimple.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EligibilityAdditionalDataV2 implements Serializable {

    @JsonProperty("operation_id")
    private String operationId;

    @JsonProperty("credit_line_id")
    private String creditLineId;

    @JsonProperty("offer_id")
    private String offerId;

    public String getOperationId() {
        return operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getCreditLineId() {
        return creditLineId;
    }

    public void setCreditLineId(String creditLineId) {
        this.creditLineId = creditLineId;
    }

    public String getOfferId() {
        return offerId;
    }

    public void setOfferId(String offerId) {
        this.offerId = offerId;
    }

    @Override
    public String toString() {
        return "EligibilityAdditionalDataV2 [" +
                ((operationId != null) ? "operationId='" + operationId + "', " : "") +
                ((creditLineId != null) ? "creditLineId='" + creditLineId + "', " : "") +
                ((offerId != null) ? "offerId='" + offerId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EligibilityAdditionalDataV2 that = (EligibilityAdditionalDataV2) o;
        return Objects.equals(operationId, that.operationId) && Objects.equals(creditLineId, that.creditLineId) && Objects.equals(offerId, that.offerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operationId, creditLineId, offerId);
    }
}