package ar.com.sdd.creditosimple.io;

import ar.com.sdd.creditosimple.entity.ErrorV1;
import ar.com.sdd.creditosimple.entity.MetaV1;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErrorV1Response {

    private MetaV1 meta;
    private List<String> data; //No deberia usarse...siempre va a venir vacio en los errores
    private List<ErrorV1> errors;

    public MetaV1 getMeta() {
        return meta;
    }

    public void setMeta(MetaV1 meta) {
        this.meta = meta;
    }

    public List<String> getData() {
        return data;
    }

    public void setData(List<String> data) {
        this.data = data;
    }

    public List<ErrorV1> getErrors() {
        return errors;
    }

    public void setErrors(List<ErrorV1> errors) {
        this.errors = errors;
    }

    @Override
    public String toString() {
        return "ErrorResponse ["
                + ((meta != null) ? "meta=" + meta + ", " : "")
                + ((data != null) ? "data=" + Arrays.toString(data.toArray()) + ", " : "")
                + ((errors != null) ? "errors=" + Arrays.toString(errors.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ErrorV1Response that = (ErrorV1Response) o;

        if (meta != null ? !meta.equals(that.meta) : that.meta != null) return false;
        if (data != null ? !data.equals(that.data) : that.data != null) return false;
        return errors != null ? errors.equals(that.errors) : that.errors == null;
    }

    @Override
    public int hashCode() {
        int result = meta != null ? meta.hashCode() : 0;
        result = 31 * result + (data != null ? data.hashCode() : 0);
        result = 31 * result + (errors != null ? errors.hashCode() : 0);
        return result;
    }
}
