package ar.com.sdd.creditosimple.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EligibilityReasonV2 implements Serializable {

    @JsonProperty("friendly_message")
    private String friendlyMessage;

    @JsonProperty("friendly_details")
    private String friendlyDetails;

    public String getFriendlyMessage() {
        return friendlyMessage;
    }

    public void setFriendlyMessage(String friendlyMessage) {
        this.friendlyMessage = friendlyMessage;
    }

    public String getFriendlyDetails() {
        return friendlyDetails;
    }

    public void setFriendlyDetails(String friendlyDetails) {
        this.friendlyDetails = friendlyDetails;
    }

    @Override
    public String toString() {
        return "EligibilityReasonV2 [" +
                ((friendlyMessage != null) ? "friendlyMessage='" + friendlyMessage + "', " : "") +
                ((friendlyDetails != null) ? "friendlyDetails='" + friendlyDetails + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EligibilityReasonV2 that = (EligibilityReasonV2) o;
        return Objects.equals(friendlyMessage, that.friendlyMessage) && Objects.equals(friendlyDetails, that.friendlyDetails);
    }

    @Override
    public int hashCode() {
        return Objects.hash(friendlyMessage, friendlyDetails);
    }
}