package ar.com.sdd.creditosimple.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class MerchantV2 implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("cuit")
    private String cuit;

    @JsonProperty("account")
    private AccountV2 account;

    @JsonProperty("email")
    private String email;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public AccountV2 getAccount() {
        return account;
    }

    public void setAccount(AccountV2 account) {
        this.account = account;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String toString() {
        return "MerchantV2 [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((cuit != null) ? "cuit='" + cuit + "', " : "") +
                ((account != null) ? "account=" + account + ", " : "") +
                ((email != null) ? "email='" + email + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MerchantV2 that = (MerchantV2) o;
        return Objects.equals(id, that.id) && Objects.equals(cuit, that.cuit) && Objects.equals(account, that.account) && Objects.equals(email, that.email);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, cuit, account, email);
    }
}