package ar.com.sdd.creditosimple.io;

import ar.com.sdd.creditosimple.entity.CreditDetails;
import ar.com.sdd.creditosimple.entity.MerchantV2;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreditCalculationV2Response implements Serializable {

    @JsonProperty("simulation_id")
    private String simulationId;

    /**
     * Este atributo no viene en el json, lo llenamos nosotros a mano porque este objeto se guarda en el settlement en el achDato3 y se usa para crear la orden, donde el merchantId es requerido
     */
    @JsonProperty("merchant")
    private MerchantV2 merchant;

    @JsonProperty("credit_details")
    private CreditDetails creditDetails;

    public String getSimulationId() {
        return simulationId;
    }

    public void setSimulationId(String simulationId) {
        this.simulationId = simulationId;
    }

    public MerchantV2 getMerchant() {
        return merchant;
    }

    public void setMerchant(MerchantV2 merchant) {
        this.merchant = merchant;
    }

    public CreditDetails getCreditDetails() {
        return creditDetails;
    }

    public void setCreditDetails(CreditDetails creditDetails) {
        this.creditDetails = creditDetails;
    }

    @Override
    public String toString() {
        return "CreditCalculationV2Response [" +
                ((simulationId != null) ? "simulationId='" + simulationId + "', " : "") +
                ((merchant != null) ? "merchant=" + merchant + ", " : "") +
                ((creditDetails != null) ? "creditDetails=" + creditDetails + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CreditCalculationV2Response that = (CreditCalculationV2Response) o;
        return Objects.equals(simulationId, that.simulationId) && Objects.equals(merchant, that.merchant) && Objects.equals(creditDetails, that.creditDetails);
    }

    @Override
    public int hashCode() {
        return Objects.hash(simulationId, merchant, creditDetails);
    }
}