package ar.com.sdd.creditosimple.io;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ErrorV2Response implements Serializable {

    @JsonProperty("statusCode")
    private Integer statusCode;

    @JsonProperty("timestamp")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "GMT-03:00")
    private Date timestamp;

    @JsonProperty("path")
    private String path;

    @JsonProperty("message")
    private String message;

    public Integer getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public Date getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return "ErrorV2Response [" +
                ((statusCode != null) ? "statusCode=" + statusCode + ", " : "") +
                ((timestamp != null) ? "timestamp=" + timestamp + ", " : "") +
                ((path != null) ? "path='" + path + "', " : "") +
                ((message != null) ? "message='" + message + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErrorV2Response that = (ErrorV2Response) o;
        return Objects.equals(statusCode, that.statusCode) && Objects.equals(timestamp, that.timestamp) && Objects.equals(path, that.path) && Objects.equals(message, that.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(statusCode, timestamp, path, message);
    }
}