package ar.com.sdd.creditosimple.io.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SimulacionRequest {
    //Para  SolaFirma:
    //  {
    //    "id_agreement": "632b7077e521b9e296518f86",
    //    "farmer_cuit": "30568143120",
    //    "amount": 3001,
    //    "financial_line_id": "1",  // Ya no es necesario
    //    "provider_id":"2",
    //    "farmer_name":"FORTIN VEGA. VIA GATEWAY" // Ya no es necesario
    //
    // Para Forward
    // {
    //    "id_agreement": "622a3bfa0db1e3000104caf8",
    //    "farmer_cuit": "30615638613",
    //    "amount": 1500001,
    //    "financial_line_id": "2",
    //    "provider_id": "101",
    //    "farmer_name": "CARLOS CHIAPPE. VIA GATEWAY"
    //    "business_type": "1",
    //    "broker_id": "61bb8825d2c1bd4fda127623",
    //}

    @JsonProperty("farmer_cuit")
    private String cuit;

    @JsonProperty("id_agreement")
    private String idConvenio;

    @JsonProperty("amount")
    private BigDecimal monto;

    @JsonProperty("financial_line_id")
    private String finantialLineId; //"1"

    @JsonProperty("provider_id")
    private String providerId; //"2"

    @JsonProperty("farmer_name")
    private String farmerName; //"FORTIN VEGA. VIA GATEWAY"

    @JsonProperty("business_type")
    private String businessType; //"1" / "2"

    @JsonProperty("broker_id")
    private String brokerId; //"61bb8825d2c1bd4fda127623"

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getIdConvenio() {
        return idConvenio;
    }

    public void setIdConvenio(String idConvenio) {
        this.idConvenio = idConvenio;
    }

    public BigDecimal getMonto() {
        return monto;
    }

    public void setMonto(BigDecimal monto) {
        this.monto = monto;
    }

    public void setFarmerName(String farmerName) { this.farmerName = farmerName;   }
    public String getFarmerName() {return farmerName;    }

    public void setFinantialLineId(String finantialLineId) { this.finantialLineId = finantialLineId;   }
    public String getFinantialLineId() {   return finantialLineId;   }

    public void setProviderId(String providerId) {this.providerId = providerId;}
    public String getProviderId() { return providerId;}

    public void setBrokerId(String brokerId) {this.brokerId = brokerId;}
    public String getBrokerId() {return brokerId;}

    public void setBusinessType(String businessType) {this.businessType = businessType;}
    public String getBusinessType() {return businessType;}




    //Compat TGR: declaro un campo para el mapeo de serializacion, pero gettter/setter los tiro al campo correcto
    @JsonProperty("cuit")
    private String compat_cuit;

    public void setCompat_cuit(String compat_cuit) {
        this.compat_cuit = compat_cuit;
        this.cuit        = compat_cuit;
    }

    public String getCompat_cuit() {
        return cuit;
    }

    @JsonProperty("id_convenio")
    private String compat_idConvenio;

    public void setCompat_idConvenio(String compat_idConvenio) {
        this.compat_idConvenio = compat_idConvenio;
        this.idConvenio        = compat_idConvenio;
    }

    public String getCompat_idConvenio() {
        return idConvenio;
    }

    @JsonProperty("monto")
    private BigDecimal compat_monto;

    public void setCompat_monto(BigDecimal compat_monto) {
        this.compat_monto = compat_monto;
        this.monto        = compat_monto;
    }

    public BigDecimal getCompat_monto() {
        return monto;
    }





    @Override
    public String toString() {
        return "SimulacionRequest [" +
                "cuit=" + cuit +
                ", idConvenio=" + idConvenio +
                ", monto=" + monto +
                ", finantialLineId=" + finantialLineId +
                ", providerId=" + providerId +
                ", farmerName=" + farmerName +
                ", businessType=" + businessType +
                ", brokerId=" + brokerId +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SimulacionRequest that = (SimulacionRequest) o;

        if (!Objects.equals(cuit, that.cuit)) return false;
        if (!Objects.equals(idConvenio, that.idConvenio)) return false;
        if (!Objects.equals(monto, that.monto)) return false;
        if (!Objects.equals(finantialLineId, that.finantialLineId)) return false;
        if (!Objects.equals(providerId, that.providerId)) return false;
        if (!Objects.equals(farmerName, that.farmerName)) return false;
        if (!Objects.equals(businessType, that.businessType)) return false;
        return Objects.equals(brokerId, that.brokerId);
    }

    @Override
    public int hashCode() {
        int result = cuit != null ? cuit.hashCode() : 0;
        result = 31 * result + (idConvenio != null ? idConvenio.hashCode() : 0);
        result = 31 * result + (monto != null ? monto.hashCode() : 0);
        result = 31 * result + (finantialLineId != null ? finantialLineId.hashCode() : 0);
        result = 31 * result + (providerId != null ? providerId.hashCode() : 0);
        result = 31 * result + (farmerName != null ? farmerName.hashCode() : 0);
        result = 31 * result + (businessType != null ? businessType.hashCode() : 0);
        result = 31 * result + (brokerId != null ? brokerId.hashCode() : 0);
        return result;
    }
}


