package ar.com.sdd.creditosimple.io.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OrdenV1Request {

    @JsonProperty("id_simulacion")
    private String idSimulacion;

    @JsonProperty("codigo_area")
    private String codigoArea;

    @JsonProperty("numero_telefono")
    private String numeroTelefono;

    @JsonProperty("email")
    private String email;

    @JsonProperty("informacion_adicional")
    private String informacionAdicional;

    public String getIdSimulacion() {
        return idSimulacion;
    }

    public void setIdSimulacion(String idSimulacion) {
        this.idSimulacion = idSimulacion;
    }

    public String getCodigoArea() {
        return codigoArea;
    }

    public void setCodigoArea(String codigoArea) {
        this.codigoArea = codigoArea;
    }

    public String getNumeroTelefono() {
        return numeroTelefono;
    }

    public void setNumeroTelefono(String numeroTelefono) {
        this.numeroTelefono = numeroTelefono;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getInformacionAdicional() {
        return informacionAdicional;
    }

    public void setInformacionAdicional(String informacionAdicional) {
        this.informacionAdicional = informacionAdicional;
    }

    @Override
    public String toString() {
        return "OrdenRequest ["
                + ((idSimulacion != null) ? "idSimulacion=" + idSimulacion + ", " : "")
                + ((codigoArea != null) ? "codigoArea=" + codigoArea + ", " : "")
                + ((numeroTelefono != null) ? "numeroTelefono=" + numeroTelefono + ", " : "")
                + ((email != null) ? "email=" + email + ", " : "")
                + ((informacionAdicional != null) ? "informacionAdicional=" + informacionAdicional : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OrdenV1Request that = (OrdenV1Request) o;

        if (idSimulacion != null ? !idSimulacion.equals(that.idSimulacion) : that.idSimulacion != null) return false;
        if (codigoArea != null ? !codigoArea.equals(that.codigoArea) : that.codigoArea != null) return false;
        if (numeroTelefono != null ? !numeroTelefono.equals(that.numeroTelefono) : that.numeroTelefono != null) return false;
        if (email != null ? !email.equals(that.email) : that.email != null) return false;
        return informacionAdicional != null ? informacionAdicional.equals(that.informacionAdicional) : that.informacionAdicional == null;
    }

    @Override
    public int hashCode() {
        int result = idSimulacion != null ? idSimulacion.hashCode() : 0;
        result = 31 * result + (codigoArea != null ? codigoArea.hashCode() : 0);
        result = 31 * result + (numeroTelefono != null ? numeroTelefono.hashCode() : 0);
        result = 31 * result + (email != null ? email.hashCode() : 0);
        result = 31 * result + (informacionAdicional != null ? informacionAdicional.hashCode() : 0);
        return result;
    }
}

