/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.cuentasimple.ejb.application;

import ar.com.sdd.cuentasimple.ejb.application.CuentaSimplePropertyManager;
import ar.com.sdd.cuentasimple.ejb.entity.Instance;
import ar.com.sdd.cuentasimple.ejb.exception.ApplicationException;
import ar.com.sdd.cuentasimple.ejb.manager.InstanceManagerBean;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.logging.Logger;

@Singleton
@Startup
public class CuentaSimpleApplicationBean {
    private static final Logger logger = Logger.getLogger(CuentaSimpleApplicationBean.class);
    @EJB
    private InstanceManagerBean instanceManager;
    private String versionName;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private OPERATION_ENVIRONMENT operationEnvironment;
    CuentaSimplePropertyManager propertyManager;

    @PostConstruct
    public void startup() {
        logger.info((Object)"Inicializando CuentaSimple...");
        Instance instance = this.instanceManager.getCurrentInstance();
        this.versionName = instance.getWebApiVersion();
        String operationEnvironmentParam = instance.getOperationEnvironment();
        this.operationEnvironment = OPERATION_ENVIRONMENT.valueOf(operationEnvironmentParam);
        logger.info((Object)("Version [" + this.versionName + "] Entorno [" + this.operationEnvironment + "]"));
        Properties commonProperties = new Properties();
        String commongPropertiesFile = "csapp_common.properties";
        InputStream commonPropertiesStream = CuentaSimpleApplicationBean.class.getClassLoader().getResourceAsStream(commongPropertiesFile);
        try {
            commonProperties.load(commonPropertiesStream);
            logger.info((Object)("Archivo de properties comunes [" + commongPropertiesFile + "] cargado"));
            commonPropertiesStream.close();
        }
        catch (IOException e) {
            throw new ApplicationException("Problema al cargar las properties comunes", e);
        }
        Properties envProperties = new Properties();
        String envPropertiesFile = "csapp_" + this.operationEnvironment + ".properties";
        InputStream envPropertiesStream = CuentaSimpleApplicationBean.class.getClassLoader().getResourceAsStream(envPropertiesFile);
        try {
            envProperties.load(envPropertiesStream);
            logger.info((Object)("Archivo de properties de entorno [" + envPropertiesFile + "] cargado"));
            envPropertiesStream.close();
        }
        catch (IOException e) {
            throw new ApplicationException("Problema al cargar las properties por entorno", e);
        }
        String ebfServerConfFile = "ebfserver.conf";
        Properties ebfserverConfProperties = new Properties();
        InputStream ebfserverConfStream = CuentaSimpleApplicationBean.class.getClassLoader().getResourceAsStream(ebfServerConfFile);
        try {
            ebfserverConfProperties.load(ebfserverConfStream);
            logger.info((Object)("Archivo de properties de ebfserver.confg [" + ebfServerConfFile + "] cargado"));
            ebfserverConfStream.close();
        }
        catch (IOException e) {
            throw new ApplicationException("Problema al cargar las properties de ebfserver.conf", e);
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)commonProperties);
        properties.putAll((Map<?, ?>)envProperties);
        properties.putAll((Map<?, ?>)ebfserverConfProperties);
        this.propertyManager = new CuentaSimplePropertyManager(properties, sdf);
        logger.info((Object)"Instalando certificado generico");
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (Exception e) {
            throw new ApplicationException("Problema al instalar el certificado generico", e);
        }
        logger.info((Object)"Fin de la inicializacion de CuentaSimple");
    }

    @PreDestroy
    public void shutdown() {
        logger.info((Object)"Apagando CuentaSimple...");
        logger.info((Object)"Fin del apagado de CuentaSimple");
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return sdf;
    }

    public CuentaSimplePropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public OPERATION_ENVIRONMENT getOperationEnvironment() {
        return this.operationEnvironment;
    }

    public boolean isDESA() {
        return this.operationEnvironment.equals((Object)OPERATION_ENVIRONMENT.DESA);
    }

    public boolean isQA() {
        return this.operationEnvironment.equals((Object)OPERATION_ENVIRONMENT.QA);
    }

    public boolean isPROD() {
        return this.operationEnvironment.equals((Object)OPERATION_ENVIRONMENT.PROD);
    }

    public String getEbfMailboxRootPath() {
        return this.propertyManager.getProperty("ebf.mailbox.root");
    }

    public String getEbfInboxPath(Long ownerId) {
        return Paths.get(this.getEbfMailboxRootPath(), this.getPropertyManager().getProperty("ebfmailbox.inbox." + ownerId)).toString();
    }

    public String getEbfOutboxPath(Long ownerId) {
        return Paths.get(this.getEbfMailboxRootPath(), this.getPropertyManager().getProperty("ebfmailbox.outbox." + ownerId)).toString();
    }

    public String getEbfProcessPath(Long ownerId) {
        return Paths.get(this.getEbfMailboxRootPath(), this.getPropertyManager().getProperty("ebfmailbox.process." + ownerId)).toString();
    }

    public String getEbfSentPath(Long ownerId) {
        return Paths.get(this.getEbfMailboxRootPath(), this.getPropertyManager().getProperty("ebfmailbox.sent." + ownerId)).toString();
    }

    public String getEbfAttachPath(Long ownerId) {
        return Paths.get(this.getEbfMailboxRootPath(), this.getPropertyManager().getProperty("ebfmailbox.attach." + ownerId)).toString();
    }

    public static enum OPERATION_ENVIRONMENT {
        DESA,
        QA,
        PROD;

    }
}

