/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.cuentasimple.ejb.service;

import ar.com.sdd.cuentasimple.ejb.application.CuentaSimpleApplicationBean;
import ar.com.sdd.cuentasimple.ejb.entity.RemoteInstance;
import ar.com.sdd.cuentasimple.ejb.manager.CacheManagerBean;
import ar.com.sdd.ebf.webapi.ErrorResponseWAPI;
import ar.com.sdd.ebf.webapi.RequestWAPI;
import ar.com.sdd.ebf.webapi.ResponseCacheable;
import ar.com.sdd.ebf.webapi.ResponseWAPI;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.jboss.logging.Logger;

@Stateless(name="ebfWAPIService")
public class EBFWebAPIServiceBean {
    private static final Logger logger = Logger.getLogger(EBFWebAPIServiceBean.class);
    @EJB
    private CuentaSimpleApplicationBean csApp;
    @EJB
    private CacheManagerBean cacheManager;

    public ResponseWAPI apiRequest(RemoteInstance remoteInstance, RequestWAPI request, Class<? extends ResponseWAPI> responseWAPIClass) {
        request.setVersionCode(Long.valueOf(0L));
        request.setVersionName(this.csApp.getVersionName());
        logger.debug((Object)("[EBFWebAPIService][apiRequest] Iniciando request para " + request));
        try {
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").create();
            JsonObject jsonResult = null;
            String actualToken = request.getToken();
            boolean isResponseCacheable = request instanceof ResponseCacheable;
            boolean foundInCache = false;
            if (isResponseCacheable) {
                jsonResult = (JsonObject)this.cacheManager.getResponseShortCache().get((Object)this.getCacheKey((ResponseCacheable)request));
                boolean bl = foundInCache = jsonResult != null;
            }
            if (!foundInCache) {
                String inputLine;
                String urlWebAPI = remoteInstance.getWebApiUrl();
                URL url = new URL(urlWebAPI);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("POST");
                String postString = gson.toJson((Object)request);
                String urlParameters = "data=" + postString;
                con.setDoOutput(true);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.writeBytes(urlParameters);
                wr.flush();
                wr.close();
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                logger.debug((Object)("[EBFWebAPIService][apiRequest] Response:" + response.toString()));
                jsonResult = new JsonParser().parse(response.toString()).getAsJsonObject();
            }
            try {
                ResponseWAPI responseWAPI = (ResponseWAPI)gson.fromJson(jsonResult, responseWAPIClass);
                if (!foundInCache && responseWAPI.getInvalidateResponseCache() != null && responseWAPI.getInvalidateResponseCache().booleanValue()) {
                    this.clearResponseCache();
                }
                if (isResponseCacheable) {
                    if (foundInCache) {
                        responseWAPI.setToken(actualToken);
                    } else {
                        this.cacheManager.getResponseShortCache().put((Object)this.getCacheKey((ResponseCacheable)request), (Object)jsonResult);
                    }
                }
                return responseWAPI;
            }
            catch (JsonSyntaxException e) {
                logger.error((Object)"[EBFWebAPIService][apiRequest] hubo un problema al recuperar el resultado JSON", (Throwable)e);
                return (ResponseWAPI)gson.fromJson((JsonElement)jsonResult, ErrorResponseWAPI.class);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            ErrorResponseWAPI errorGrave = new ErrorResponseWAPI();
            errorGrave.setResultCode(ResponseWAPI.Codes.ERROR_GRAVE);
            errorGrave.setResultMessage("Error grave. Consulte soporte");
            logger.error((Object)"[EBFWebAPIService][apiRequest] error grave en la comunicacion", (Throwable)e);
            return errorGrave;
        }
    }

    public void clearResponseCache() {
        logger.info((Object)"[EBFWebAPIService][apiRequest] Se solicito un clear de la cache");
        this.cacheManager.getResponseShortCache().clear();
    }

    private Integer getCacheKey(ResponseCacheable responseCacheable) {
        Integer key = responseCacheable.getRequestCacheKey();
        return key;
    }
}

