/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.cuentasimple.ejb.service;

import ar.com.sdd.cuentasimple.ejb.application.CuentaSimpleApplicationBean;
import ar.com.sdd.cuentasimple.ejb.application.CuentaSimplePropertyManager;
import ar.com.sdd.cuentasimple.ejb.entity.RemoteInstance;
import ar.com.sdd.cuentasimple.ejb.exception.ApplicationException;
import ar.com.sdd.cuentasimple.ejb.pojo.BoletaContainer;
import ar.com.sdd.cuentasimple.ejb.pojo.IdCard;
import ar.com.sdd.cuentasimple.ejb.util.FileToolkit;
import ar.com.sdd.cuentasimple.ejb.util.GroovyContext;
import ar.com.sdd.cuentasimple.ejb.util.GroovyParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

@Stateless
public class PdfServiceBean {
    private static final Logger logger = Logger.getLogger(PdfServiceBean.class);
    @EJB
    CuentaSimpleApplicationBean csApp;

    public void generateIdCardPDF(RemoteInstance remoteInstance, IdCard idCard, OutputStream outputStream) {
        logger.debug((Object)("Generando PDF tarjeta para idCard [" + idCard + "]"));
        List<IdCard> beans = Collections.singletonList(idCard);
        Long ownerId = idCard.getCollector().getId();
        String resource = this.csApp.getPropertyManager().getPropertyInstanciated("idcard", null, ownerId, idCard.getCompanyAccount().getBank().getCode());
        GroovyContext ctx = new GroovyContext();
        ctx.idCard = idCard;
        ctx.ownerId = ownerId;
        this.generatePDFHelper(remoteInstance, ownerId, outputStream, beans, resource, ctx);
    }

    public void generateBoletaPDF(RemoteInstance remoteInstance, BoletaContainer boletaContainer, OutputStream outputStream) {
        logger.debug((Object)("Generando PDF boleta para la boleta [" + boletaContainer.getBoleta() + "]"));
        List<BoletaContainer> beans = Collections.singletonList(boletaContainer);
        Long ownerId = boletaContainer.getBoleta().getOwner().getId();
        String resource = this.csApp.getPropertyManager().getPropertyInstanciated("boleta", null, ownerId, boletaContainer.getBoleta().getCollectorAccount().getBank().getCode());
        GroovyContext ctx = new GroovyContext();
        ctx.boletaContainer = boletaContainer;
        ctx.ownerId = ownerId;
        this.generatePDFHelper(remoteInstance, ownerId, outputStream, beans, resource, ctx);
    }

    private void generatePDFHelper(RemoteInstance remoteInstance, Long ownerId, OutputStream outputStream, Collection<?> beans, String resource, GroovyContext ctx) {
        String reportPath = this.csApp.getPropertyManager().getProperty("cs.report.path");
        String reportFile = Paths.get(reportPath, resource).toString();
        logger.debug((Object)("Generando PDF para el reporte [" + resource + "]"));
        InputStream reportStream = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String imagesPath = Paths.get(reportPath, "images").toString();
            params.put("imagesPath", imagesPath);
            Collection reports = FileUtils.listFiles((File)new File(reportPath), (String[])new String[]{"jrxml"}, (boolean)false);
            if (CollectionUtils.isNotEmpty((Collection)reports)) {
                for (File reportSource : reports) {
                    File reportBinary = new File(reportSource.getAbsolutePath().replace("jrxml", "jasper"));
                    if (reportBinary.exists() && reportSource.lastModified() <= reportBinary.lastModified()) continue;
                    try {
                        JasperCompileManager.compileReportToFile((String)reportSource.getAbsolutePath(), (String)reportBinary.getAbsolutePath());
                    }
                    catch (Exception e) {
                        logger.error((Object)"Recompilando reportes", (Throwable)e);
                    }
                }
            }
            reportStream = new FileInputStream(new File(reportFile));
            Properties jasperProps = new Properties();
            params.put("props", jasperProps);
            if (ctx == null) {
                ctx = new GroovyContext();
            }
            GroovyParser groovyParser = new GroovyParser(ctx);
            this.processBarcodes(remoteInstance, ownerId, jasperProps, groovyParser);
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)reportStream);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, params, (JRDataSource)new JRBeanCollectionDataSource(beans));
            JRPdfExporter exporter = new JRPdfExporter();
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.exportReport();
        }
        catch (Exception e) {
            throw new ApplicationException("Error en el reporte [" + reportFile + "]", e);
        }
        finally {
            if (reportStream != null) {
                try {
                    reportStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Problemas al cerrar el stream", (Throwable)e);
                }
            }
        }
    }

    private void processBarcodes(RemoteInstance remoteInstance, Long ownerId, Properties jasperProps, GroovyParser groovyParser) {
        boolean created;
        String attachBarcodesPath = Paths.get(this.csApp.getEbfAttachPath(ownerId), "barcodes").toString();
        File attachBarcodesPathFolder = new File(attachBarcodesPath);
        if (!attachBarcodesPathFolder.exists() && !(created = attachBarcodesPathFolder.mkdirs())) {
            logger.error((Object)("No se creo la carpeta [" + attachBarcodesPath + "]"));
        }
        int i = 1;
        String barcodeDataKey = this.getBarcodePropKey(ownerId, "data", i);
        CuentaSimplePropertyManager propertiesUtil = this.csApp.getPropertyManager();
        while (this.csApp.getPropertyManager().containsKey(barcodeDataKey)) {
            String barcodeDataValue = groovyParser.evalString(propertiesUtil.getProperty(barcodeDataKey));
            String barcodeFilenameKey = this.getBarcodePropKey(ownerId, "filename", i);
            String barcodeFilenameValue = groovyParser.evalString(propertiesUtil.getProperty(barcodeFilenameKey));
            String barcodeTypeKey = this.getBarcodePropKey(ownerId, "type", i);
            String barcodeTypeValue = groovyParser.evalString(propertiesUtil.getProperty(barcodeTypeKey));
            jasperProps.put(barcodeDataKey, barcodeDataValue);
            jasperProps.put(barcodeFilenameKey, barcodeFilenameValue);
            jasperProps.put(barcodeTypeKey, barcodeTypeValue);
            if (!StringUtils.isEmpty((CharSequence)barcodeFilenameValue)) {
                String filenameFullPath = Paths.get(attachBarcodesPath, barcodeFilenameValue).toString();
                logger.debug((Object)("Se encontro el barcode que apunta a [" + filenameFullPath + "] con valor [" + barcodeDataValue + "]"));
                jasperProps.put(barcodeFilenameKey, filenameFullPath);
                if (!new File(filenameFullPath).exists()) {
                    logger.debug((Object)("Se va a ejecutar generador de codigos de barra para el archivo [" + filenameFullPath + "]"));
                    String scriptFullPath = Paths.get("/usr/local/sbin/ebfscripts/", "barcodegenerator.sh").toString();
                    String[] args = new String[]{scriptFullPath, String.valueOf(remoteInstance.getId()), remoteInstance.getOperationEnvironment(), barcodeTypeValue, barcodeDataValue, filenameFullPath};
                    int result = FileToolkit.executeScript(args);
                    if (result != 0) {
                        logger.error((Object)("Hubo un problema al ejecutar el generador de codigos de barra para el archivo [" + filenameFullPath + "]"));
                    }
                }
            }
            barcodeDataKey = this.getBarcodePropKey(ownerId, "data", ++i);
        }
    }

    private String getBarcodePropKey(Long ownerId, String propType, int i) {
        return "barcode." + propType + "." + ownerId + "." + StringUtils.leftPad((String)("" + i), (int)2, (String)"0");
    }
}

