/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.cuentasimple.ejb.service;

import ar.com.sdd.cuentasimple.ejb.entity.RemoteInstance;
import ar.com.sdd.cuentasimple.ejb.exception.ServiceException;
import ar.com.sdd.cuentasimple.ejb.pojo.CreateOperatorDataResult;
import ar.com.sdd.cuentasimple.ejb.pojo.DefaultOperatorDataResult;
import ar.com.sdd.cuentasimple.ejb.service.DataServiceBean;
import ar.com.sdd.cuentasimple.ejb.service.EBFWebAPIServiceBean;
import ar.com.sdd.ebf.bo.webapi.OperatorWAPI;
import ar.com.sdd.ebf.bo.webapi.RightSetWAPI;
import ar.com.sdd.ebf.webapi.RequestWAPI;
import ar.com.sdd.ebf.webapi.ResponseWAPI;
import ar.com.sdd.ebf.webapi.crud.operator.OperatorCRUDRequestWAPI;
import ar.com.sdd.ebf.webapi.crud.operator.OperatorCRUDResponseWAPI;
import ar.com.sdd.ebf.webapi.rights.GetRightRequest;
import ar.com.sdd.ebf.webapi.rights.GetRightRequestWAPI;
import ar.com.sdd.ebf.webapi.rights.GetRightResponse;
import ar.com.sdd.ebf.webapi.rights.GetRightResponseWAPI;
import ar.com.sdd.ebf.webapi.rights.SetRightRequest;
import ar.com.sdd.ebf.webapi.rights.SetRightRequestWAPI;
import ar.com.sdd.ebf.webapi.rights.SetRightResponseWAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

@Stateless
public class SecurityServiceBean {
    private static final Logger logger = Logger.getLogger(SecurityServiceBean.class);
    @EJB
    private EBFWebAPIServiceBean ebfWAPIService;
    @EJB
    private DataServiceBean dataService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CreateOperatorDataResult createOperator(String token, String sessionId, RemoteInstance remoteInstance, OperatorWAPI newOperator, RightSetWAPI actualOperatorRights) throws ServiceException {
        logger.debug((Object)("Creando nuevo operador [" + newOperator + "]"));
        CreateOperatorDataResult result = new CreateOperatorDataResult();
        if (newOperator == null) return result;
        OperatorCRUDRequestWAPI request = new OperatorCRUDRequestWAPI(token, sessionId, newOperator, RequestWAPI.CRUDMode.CREATE);
        ResponseWAPI response = this.ebfWAPIService.apiRequest(remoteInstance, (RequestWAPI)request, OperatorCRUDResponseWAPI.class);
        String newToken = response.getToken();
        result.setNewToken(newToken);
        if (!response.getResultCode().equals((Object)ResponseWAPI.Codes.OK_CRUD_OPERATOR)) throw new ServiceException(response);
        OperatorCRUDResponseWAPI operatorCRUDResponse = (OperatorCRUDResponseWAPI)response;
        OperatorWAPI operator = operatorCRUDResponse.getOperator();
        result.setCreatedOperator(operator);
        logger.debug((Object)"Operador creado");
        String newOperatorAttributesConfig = actualOperatorRights.getConfig("NEW.OPERATOR.CS.PROFILE");
        logger.debug((Object)("El derecho NEW.OPERATOR.CS.PROFILE, tiene los valores [" + newOperatorAttributesConfig + "]"));
        DefaultOperatorDataResult defaultOperatorResult = this.dataService.getDefaultOperator(sessionId, remoteInstance, newToken, operator.getCompanyWAPI());
        newToken = defaultOperatorResult.getNewToken();
        result.setNewToken(newToken);
        OperatorWAPI defaultOperator = defaultOperatorResult.getDefaultOperator();
        logger.debug((Object)("Operador por default [" + defaultOperator + "]"));
        ArrayList<GetRightRequest> rightRequests = new ArrayList<GetRightRequest>();
        List<String> newOperatorAttributesConfigs = Arrays.asList(StringUtils.split((String)newOperatorAttributesConfig, (char)'|'));
        for (String newConfigTag : newOperatorAttributesConfigs) {
            rightRequests.add(new GetRightRequest(newConfigTag, GetRightRequest.RIGHT_TYPE.HAS_PROFILE, GetRightRequest.RESULT_TYPE.BOOLEAN));
        }
        if (CollectionUtils.isEmpty(rightRequests)) return result;
        logger.debug((Object)("Consulto por los derechos del defaultOperator [" + rightRequests + "]"));
        GetRightRequestWAPI getRightRequest = new GetRightRequestWAPI(newToken, sessionId, defaultOperator.getId(), rightRequests);
        response = this.ebfWAPIService.apiRequest(remoteInstance, (RequestWAPI)getRightRequest, GetRightResponseWAPI.class);
        newToken = response.getToken();
        result.setNewToken(newToken);
        GetRightResponseWAPI getRightResponse = (GetRightResponseWAPI)response;
        if (!getRightResponse.getResultCode().equals((Object)ResponseWAPI.Codes.OK_GET_RIGHT)) throw new ServiceException((ResponseWAPI)getRightResponse);
        ArrayList<String> perfilesNuevos = new ArrayList<String>();
        for (int i = 0; i < getRightResponse.getRightResponses().size(); ++i) {
            GetRightResponse rightResponse = (GetRightResponse)getRightResponse.getRightResponses().get(i);
            if (!rightResponse.getBooleanResult().booleanValue()) continue;
            perfilesNuevos.add(newOperatorAttributesConfigs.get(i));
        }
        if (!CollectionUtils.isEmpty(perfilesNuevos)) {
            logger.debug((Object)("Se le va a agregar al nuevo operador los perfiles [" + perfilesNuevos + "]"));
            ArrayList<SetRightRequest> setRightRequests = new ArrayList<SetRightRequest>();
            for (String perfilNuevo : perfilesNuevos) {
                setRightRequests.add(new SetRightRequest(SetRightRequest.RIGHT_TABLE.RIGHT_OPERATOR, perfilNuevo, SetRightRequest.RIGHT_TYPE.PERFIL, "*"));
            }
            SetRightRequestWAPI setRightRequestWAPI = new SetRightRequestWAPI(newToken, sessionId, operator.getId(), setRightRequests);
            response = this.ebfWAPIService.apiRequest(remoteInstance, (RequestWAPI)setRightRequestWAPI, SetRightResponseWAPI.class);
            newToken = response.getToken();
            result.setNewToken(newToken);
            SetRightResponseWAPI setRightResponse = (SetRightResponseWAPI)response;
            if (!setRightResponse.getResultCode().equals((Object)ResponseWAPI.Codes.OK_SET_RIGHT)) throw new ServiceException((ResponseWAPI)setRightResponse);
            logger.debug((Object)"Se agregaron los perfiles exitosamente");
            return result;
        } else {
            logger.debug((Object)"No hay perfiles para agregarle al operador nuevo");
        }
        return result;
    }
}

