/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.cuentasimple.ejb.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.jboss.logging.Logger;

public class FileToolkit {
    public static final String EBFSCRIPTS_PATH = "/usr/local/sbin/ebfscripts/";
    public static final String SCRIPT_BARCODE_GENERATOR_FILENAME = "barcodegenerator.sh";
    private static final Logger logger = Logger.getLogger(FileToolkit.class);

    public static int executeScript(String[] args) {
        int exitValue = -1;
        logger.debug((Object)("Por ejecutar script con parametros " + Arrays.toString(args)));
        try {
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.redirectErrorStream(true);
            OutputExecToBuffer outputExecToBuffer = new OutputExecToBuffer();
            outputExecToBuffer.setProcessRunning(true);
            Process p = pb.start();
            outputExecToBuffer.setInputStream(p.getInputStream());
            outputExecToBuffer.start();
            p.waitFor();
            outputExecToBuffer.setProcessRunning(false);
            exitValue = p.exitValue();
        }
        catch (Exception e) {
            logger.error((Object)"Error en ejecucion de script", (Throwable)e);
        }
        return exitValue;
    }

    public static class OutputExecToBuffer
    extends Thread {
        private boolean processRunning;
        private InputStream inputStream;

        public void setProcessRunning(boolean processRunning) {
            this.processRunning = processRunning;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            while (this.processRunning) {
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream));
                    while ((line = br.readLine()) != null) {
                        logger.info((Object)line);
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Ha ocurrido un error", (Throwable)e);
                }
            }
        }
    }
}

