/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.cuentasimple.ejb.application;

import ar.com.sdd.cuentasimple.ejb.exception.ApplicationException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class CuentaSimplePropertyManager {
    private Properties properties;
    private SimpleDateFormat sdf;

    public CuentaSimplePropertyManager(Properties properties, SimpleDateFormat sdf) {
        this.properties = properties;
        this.sdf = sdf;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Long getLongProperty(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            return Long.valueOf(value);
        }
        return null;
    }

    public Integer getIntegerProperty(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public Boolean getBooleanProperty(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public Date getDateProperty(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return this.sdf.parse(value);
            }
            catch (ParseException e) {
                throw new ApplicationException("Error al parsear property fecha con key [" + key + "] y value [" + value + "]", e);
            }
        }
        return null;
    }

    public String getPropertyInstanciated(String key, Long instanceId, Long companyId, String bankCode) {
        String bankKey;
        String companyKey;
        String result = null;
        String DEFAULT = "default";
        String instanceKey = instanceId != null ? instanceId.toString() : "default";
        result = this.properties.getProperty(key + "." + instanceKey + "." + (companyKey = companyId != null ? companyId.toString() : "default") + "." + (bankKey = bankCode != null ? bankCode : "default"));
        if (result == null) {
            result = this.properties.getProperty(key + ".default." + companyKey + "." + bankKey);
        }
        if (result == null) {
            result = this.properties.getProperty(key + ".default.default." + bankKey);
        }
        if (result == null) {
            result = this.properties.getProperty(key + ".default.default.default");
        }
        if (result == null) {
            throw new ApplicationException("No se encontro la key [" + key + "] con instanceId [" + instanceId + "], companyId [" + companyId + "] y bankCode [" + bankCode + "]");
        }
        return result;
    }

    public Integer getIntegerPropertyInstanciated(String key, Long instanceId, Long companyId, String bankCode) {
        String value = this.getPropertyInstanciated(key, instanceId, companyId, bankCode);
        return Integer.valueOf(value);
    }
}

