/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.cuentasimple.ejb.service;

import ar.com.sdd.ebf.bo.webapi.CompanyAccountWAPI;
import ar.com.sdd.ebf.bo.webapi.DocumentWAPI;
import ar.com.sdd.ebf.bo.webapi.OperatorWAPI;
import java.math.BigDecimal;
import javax.ejb.Stateless;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

@Stateless
public class BankServiceBean {
    private static final Logger logger = Logger.getLogger(BankServiceBean.class);

    public String citiCalculoDigitoVerificador(String input) {
        logger.debug((Object)"Calculando digito verificador Citi");
        return "9";
    }

    public String citiBoletaBarcode(DocumentWAPI boleta) {
        String lockbox = StringUtils.right((String)StringUtils.leftPad((String)boleta.getCollectorAccount().getBranchCode(), (int)5, (char)'0'), (int)5);
        String nroBoleta = StringUtils.right((String)StringUtils.leftPad((String)boleta.getLegalDocRef(), (int)6, (char)'0'), (int)6);
        String nroCliente = StringUtils.right((String)StringUtils.leftPad((String)boleta.getPayer().getCuit(), (int)10, (char)'0'), (int)10);
        String tipoDoc = StringUtils.leftPad((String)"1", (int)10, (char)'0');
        String referencia = StringUtils.right((String)StringUtils.leftPad((String)boleta.getLegalDocRef(), (int)10, (char)'0'), (int)10);
        BigDecimal importeDecimal = boleta.getDueAmount().setScale(2, 4);
        String importe = StringUtils.right((String)StringUtils.leftPad((String)importeDecimal.toString().replace(".", ""), (int)9, (char)'0'), (int)9);
        return lockbox + nroBoleta + nroCliente + tipoDoc + referencia + importe;
    }

    public String citiCalculoBarcode(CompanyAccountWAPI companyAccount, OperatorWAPI operator) {
        String branchCode = "";
        if (companyAccount != null && companyAccount.getBranchCode() != null && companyAccount.getBranchCode().length() > 1) {
            branchCode = companyAccount.getBranchCode().substring(1);
        }
        String lockbox = StringUtils.leftPad((String)branchCode, (int)4, (char)'0');
        String externalReference = "";
        if (operator.getExternalSystemReference() != null) {
            externalReference = operator.getExternalSystemReference();
        }
        String cuenta = StringUtils.leftPad((String)externalReference, (int)11, (char)'0');
        String dv = this.citiCalculoDigitoVerificador(lockbox + cuenta);
        String result = lockbox + cuenta + dv;
        logger.debug((Object)("El calculo del codigo de barras para companyAccount [" + companyAccount + "], operator [" + operator + "] es [" + result + "]"));
        if (result.length() != 16) {
            logger.error((Object)("El calculo del codigo de barras no dio de 16 posiciones para companyAccount [" + companyAccount + "], operator [" + operator + "] es [" + result + "]"));
        }
        return result;
    }
}

