/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.cuentasimple.ejb.service;

import ar.com.sdd.cuentasimple.ejb.application.CuentaSimpleApplicationBean;
import ar.com.sdd.cuentasimple.ejb.entity.RemoteInstance;
import ar.com.sdd.cuentasimple.ejb.exception.ServiceException;
import ar.com.sdd.cuentasimple.ejb.pojo.CompanyAccountsDEPDataResult;
import ar.com.sdd.cuentasimple.ejb.pojo.ConsoleDataResult;
import ar.com.sdd.cuentasimple.ejb.pojo.DefaultOperatorDataResult;
import ar.com.sdd.cuentasimple.ejb.service.EBFWebAPIServiceBean;
import ar.com.sdd.ebf.bo.webapi.CompanyWAPI;
import ar.com.sdd.ebf.bo.webapi.OperatorWAPI;
import ar.com.sdd.ebf.bo.webapi.QueryParameterWAPI;
import ar.com.sdd.ebf.bo.webapi.QueryWAPI;
import ar.com.sdd.ebf.webapi.RequestWAPI;
import ar.com.sdd.ebf.webapi.ResponseWAPI;
import ar.com.sdd.ebf.webapi.company.DefaultOperatorRequestWAPI;
import ar.com.sdd.ebf.webapi.company.DefaultOperatorResponseWAPI;
import ar.com.sdd.ebf.webapi.multiquery.MultiQueryRequestWAPI;
import ar.com.sdd.ebf.webapi.multiquery.MultiQueryResponseWAPI;
import ar.com.sdd.ebf.webapi.rights.GetRightRequest;
import ar.com.sdd.ebf.webapi.rights.GetRightRequestWAPI;
import ar.com.sdd.ebf.webapi.rights.GetRightResponse;
import ar.com.sdd.ebf.webapi.rights.GetRightResponseWAPI;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jboss.logging.Logger;

@Stateless
public class DataServiceBean {
    private static final Logger logger = Logger.getLogger(DataServiceBean.class);
    @EJB
    private EBFWebAPIServiceBean ebfWAPIService;
    @EJB
    CuentaSimpleApplicationBean csApp;

    public ConsoleDataResult consoleData(String sessionId, RemoteInstance remoteInstance, String token, CompanyWAPI actualPayer, OperatorWAPI operatorWAPI, Boolean hasSubPayers, Date processDate) throws ServiceException {
        SimpleDateFormat sdf = this.csApp.getSimpleDateFormat();
        Date firstDayOfMonth = DateUtils.truncate((Date)processDate, (int)2);
        Date firstDayOfPrevMonth = DateUtils.truncate((Date)DateUtils.addMonths((Date)processDate, (int)-1), (int)2);
        Date lastDayOfPrevMonth = DateUtils.addDays((Date)DateUtils.truncate((Date)processDate, (int)2), (int)-1);
        ArrayList<QueryWAPI> queries = new ArrayList<QueryWAPI>();
        QueryWAPI queryTotalDepositos = new QueryWAPI();
        Object queryStringTotalDepositos = "select sum(d.dueAmount) from Document d where d.typeId='DEP' and d.statusId = 'APG' and d.payerId = :payerId and d.visibility > 0";
        if (!hasSubPayers.booleanValue()) {
            queryStringTotalDepositos = (String)queryStringTotalDepositos + " and d.subPayer = :subPayer";
        }
        queryTotalDepositos.setQuery((String)queryStringTotalDepositos);
        ArrayList<QueryParameterWAPI> parametersTotalDepositos = new ArrayList<QueryParameterWAPI>();
        parametersTotalDepositos.add(new QueryParameterWAPI("payerId", QueryParameterWAPI.QUERY_PARAMETER_TYPE.LONG, actualPayer.getId().toString()));
        if (!hasSubPayers.booleanValue()) {
            parametersTotalDepositos.add(new QueryParameterWAPI("subPayer", QueryParameterWAPI.QUERY_PARAMETER_TYPE.LONG, operatorWAPI.getId().toString()));
        }
        queryTotalDepositos.setParameters(parametersTotalDepositos);
        queries.add(queryTotalDepositos);
        QueryWAPI queryTotalDepositosNoConformados = new QueryWAPI();
        Object queryStringTotalDepositosNoConformados = "select sum(d.dueAmount) from Document d where d.typeId='DEP' and d.statusId = 'NEW' and d.payerId = :payerId and d.visibility > 0";
        if (!hasSubPayers.booleanValue()) {
            queryStringTotalDepositosNoConformados = (String)queryStringTotalDepositosNoConformados + " and d.subPayer = :subPayer";
        }
        queryTotalDepositosNoConformados.setQuery((String)queryStringTotalDepositosNoConformados);
        ArrayList<QueryParameterWAPI> parametersTotalDepositosNoConformados = new ArrayList<QueryParameterWAPI>();
        parametersTotalDepositosNoConformados.add(new QueryParameterWAPI("payerId", QueryParameterWAPI.QUERY_PARAMETER_TYPE.LONG, actualPayer.getId().toString()));
        if (!hasSubPayers.booleanValue()) {
            parametersTotalDepositosNoConformados.add(new QueryParameterWAPI("subPayer", QueryParameterWAPI.QUERY_PARAMETER_TYPE.LONG, operatorWAPI.getId().toString()));
        }
        queryTotalDepositosNoConformados.setParameters(parametersTotalDepositosNoConformados);
        queries.add(queryTotalDepositosNoConformados);
        QueryWAPI queryDepositosSinSubpayerMesAnterior = new QueryWAPI();
        Object queryStringDepositosSinSubpayerMesAnterior = "select d.statusId, sum(d.dueAmount) from Document d where d.typeId='DEP' and d.statusId <> 'DEL' and d.payerId = :payerId and d.visibility > 0";
        queryStringDepositosSinSubpayerMesAnterior = (String)queryStringDepositosSinSubpayerMesAnterior + " and d.creationDate >= :fromDate and d.creationDate <= :toDate ";
        queryStringDepositosSinSubpayerMesAnterior = (String)queryStringDepositosSinSubpayerMesAnterior + " group by d.statusId ";
        queryStringDepositosSinSubpayerMesAnterior = (String)queryStringDepositosSinSubpayerMesAnterior + " order by d.statusId ";
        queryDepositosSinSubpayerMesAnterior.setQuery((String)queryStringDepositosSinSubpayerMesAnterior);
        ArrayList<QueryParameterWAPI> parametersDepositosSinSubpayerMesAnterior = new ArrayList<QueryParameterWAPI>();
        parametersDepositosSinSubpayerMesAnterior.add(new QueryParameterWAPI("payerId", QueryParameterWAPI.QUERY_PARAMETER_TYPE.LONG, actualPayer.getId().toString()));
        parametersDepositosSinSubpayerMesAnterior.add(new QueryParameterWAPI("fromDate", QueryParameterWAPI.QUERY_PARAMETER_TYPE.DATE, sdf.format(firstDayOfPrevMonth)));
        parametersDepositosSinSubpayerMesAnterior.add(new QueryParameterWAPI("toDate", QueryParameterWAPI.QUERY_PARAMETER_TYPE.DATE, sdf.format(lastDayOfPrevMonth)));
        queryDepositosSinSubpayerMesAnterior.setParameters(parametersDepositosSinSubpayerMesAnterior);
        queries.add(queryDepositosSinSubpayerMesAnterior);
        QueryWAPI queryDepositosSubpayerMesAnterior = new QueryWAPI();
        Object queryStringDepositosSubpayerMesAnterior = "select o.name, d.statusId, sum(d.dueAmount) from Document d, Operator o where d.typeId='DEP' and d.statusId <> 'DEL' and d.payerId = :payerId and d.subPayer = o.id and d.visibility > 0";
        if (!hasSubPayers.booleanValue()) {
            queryStringDepositosSubpayerMesAnterior = (String)queryStringDepositosSubpayerMesAnterior + " and d.subPayer = :subPayer";
        }
        queryStringDepositosSubpayerMesAnterior = (String)queryStringDepositosSubpayerMesAnterior + " and d.creationDate >= :fromDate and d.creationDate <= :toDate ";
        queryStringDepositosSubpayerMesAnterior = (String)queryStringDepositosSubpayerMesAnterior + " group by o.name, d.statusId ";
        queryStringDepositosSubpayerMesAnterior = (String)queryStringDepositosSubpayerMesAnterior + " order by o.name, d.statusId ";
        queryDepositosSubpayerMesAnterior.setQuery((String)queryStringDepositosSubpayerMesAnterior);
        ArrayList<QueryParameterWAPI> parametersDepositosSubpayerMesAnterior = new ArrayList<QueryParameterWAPI>();
        parametersDepositosSubpayerMesAnterior.add(new QueryParameterWAPI("payerId", QueryParameterWAPI.QUERY_PARAMETER_TYPE.LONG, actualPayer.getId().toString()));
        if (!hasSubPayers.booleanValue()) {
            parametersDepositosSubpayerMesAnterior.add(new QueryParameterWAPI("subPayer", QueryParameterWAPI.QUERY_PARAMETER_TYPE.LONG, operatorWAPI.getId().toString()));
        }
        parametersDepositosSubpayerMesAnterior.add(new QueryParameterWAPI("fromDate", QueryParameterWAPI.QUERY_PARAMETER_TYPE.DATE, sdf.format(firstDayOfPrevMonth)));
        parametersDepositosSubpayerMesAnterior.add(new QueryParameterWAPI("toDate", QueryParameterWAPI.QUERY_PARAMETER_TYPE.DATE, sdf.format(lastDayOfPrevMonth)));
        queryDepositosSubpayerMesAnterior.setParameters(parametersDepositosSubpayerMesAnterior);
        queries.add(queryDepositosSubpayerMesAnterior);
        QueryWAPI queryDepositosSinSubpayerMTD = new QueryWAPI();
        Object queryStringDepositosSinSubpayerMTD = "select d.statusId, sum(d.dueAmount) from Document d where d.typeId='DEP' and d.statusId <> 'DEL' and d.payerId = :payerId  and d.visibility > 0";
        queryStringDepositosSinSubpayerMTD = (String)queryStringDepositosSinSubpayerMTD + " and d.creationDate >= :fromDate and d.creationDate <= :toDate ";
        queryStringDepositosSinSubpayerMTD = (String)queryStringDepositosSinSubpayerMTD + " group by d.statusId ";
        queryStringDepositosSinSubpayerMTD = (String)queryStringDepositosSinSubpayerMTD + " order by d.statusId ";
        queryDepositosSinSubpayerMTD.setQuery((String)queryStringDepositosSinSubpayerMTD);
        ArrayList<QueryParameterWAPI> parametersDepositosSinSubpayerMTD = new ArrayList<QueryParameterWAPI>();
        parametersDepositosSinSubpayerMTD.add(new QueryParameterWAPI("payerId", QueryParameterWAPI.QUERY_PARAMETER_TYPE.LONG, actualPayer.getId().toString()));
        parametersDepositosSinSubpayerMTD.add(new QueryParameterWAPI("fromDate", QueryParameterWAPI.QUERY_PARAMETER_TYPE.DATE, sdf.format(firstDayOfMonth)));
        parametersDepositosSinSubpayerMTD.add(new QueryParameterWAPI("toDate", QueryParameterWAPI.QUERY_PARAMETER_TYPE.DATE, sdf.format(processDate)));
        queryDepositosSinSubpayerMTD.setParameters(parametersDepositosSinSubpayerMTD);
        queries.add(queryDepositosSinSubpayerMTD);
        QueryWAPI queryDepositosSubpayerMTD = new QueryWAPI();
        Object queryStringDepositosSubpayerMTD = "select o.name, d.statusId, sum(d.dueAmount) from Document d, Operator o where d.typeId='DEP' and d.statusId <> 'DEL' and d.payerId = :payerId and d.subPayer = o.id and d.visibility > 0";
        if (!hasSubPayers.booleanValue()) {
            queryStringDepositosSubpayerMTD = (String)queryStringDepositosSubpayerMTD + " and d.subPayer = :subPayer";
        }
        queryStringDepositosSubpayerMTD = (String)queryStringDepositosSubpayerMTD + " and d.creationDate >= :fromDate and d.creationDate <= :toDate ";
        queryStringDepositosSubpayerMTD = (String)queryStringDepositosSubpayerMTD + " group by o.name, d.statusId ";
        queryStringDepositosSubpayerMTD = (String)queryStringDepositosSubpayerMTD + " order by o.name, d.statusId ";
        queryDepositosSubpayerMTD.setQuery((String)queryStringDepositosSubpayerMTD);
        ArrayList<QueryParameterWAPI> parametersDepositosSubpayerMTD = new ArrayList<QueryParameterWAPI>();
        parametersDepositosSubpayerMTD.add(new QueryParameterWAPI("payerId", QueryParameterWAPI.QUERY_PARAMETER_TYPE.LONG, actualPayer.getId().toString()));
        if (!hasSubPayers.booleanValue()) {
            parametersDepositosSubpayerMTD.add(new QueryParameterWAPI("subPayer", QueryParameterWAPI.QUERY_PARAMETER_TYPE.LONG, operatorWAPI.getId().toString()));
        }
        parametersDepositosSubpayerMTD.add(new QueryParameterWAPI("fromDate", QueryParameterWAPI.QUERY_PARAMETER_TYPE.DATE, sdf.format(firstDayOfMonth)));
        parametersDepositosSubpayerMTD.add(new QueryParameterWAPI("toDate", QueryParameterWAPI.QUERY_PARAMETER_TYPE.DATE, sdf.format(processDate)));
        queryDepositosSubpayerMTD.setParameters(parametersDepositosSubpayerMTD);
        queries.add(queryDepositosSubpayerMTD);
        ConsoleDataResult dataResult = new ConsoleDataResult();
        MultiQueryRequestWAPI request = new MultiQueryRequestWAPI(token, sessionId, queries);
        ResponseWAPI response = this.ebfWAPIService.apiRequest(remoteInstance, (RequestWAPI)request, MultiQueryResponseWAPI.class);
        dataResult.setNewToken(response.getToken());
        if (response.getResultCode().equals((Object)ResponseWAPI.Codes.OK_MULTIQUERY)) {
            MultiQueryResponseWAPI multiQueryResponse = (MultiQueryResponseWAPI)response;
            List queryResults = multiQueryResponse.getQueryResults();
            if (!CollectionUtils.isEmpty((Collection)queryResults)) {
                List totalDepositosResult = (List)queryResults.get(0);
                if (!CollectionUtils.isEmpty((Collection)totalDepositosResult) && totalDepositosResult.get(0) != null) {
                    dataResult.setTotalDepositosSinAplicar(BigDecimal.valueOf((Double)totalDepositosResult.get(0)));
                } else {
                    dataResult.setTotalDepositosSinAplicar(BigDecimal.ZERO);
                }
                List totalDepositosNoConformadosResult = (List)queryResults.get(1);
                if (!CollectionUtils.isEmpty((Collection)totalDepositosNoConformadosResult) && totalDepositosNoConformadosResult.get(0) != null) {
                    dataResult.setTotalDepositosNoConformados(BigDecimal.valueOf((Double)totalDepositosNoConformadosResult.get(0)));
                } else {
                    dataResult.setTotalDepositosNoConformados(BigDecimal.ZERO);
                }
                List depositosSinSubpayerResult = (List)queryResults.get(2);
                ArrayList<ConsoleDataResult.DepositoSinSubpayer> depositosSinSubpayerMesAnterior = new ArrayList<ConsoleDataResult.DepositoSinSubpayer>();
                if (!CollectionUtils.isEmpty((Collection)depositosSinSubpayerResult)) {
                    for (Object row : depositosSinSubpayerResult) {
                        List rowItems = (List)row;
                        ConsoleDataResult.DepositoSinSubpayer dep = new ConsoleDataResult.DepositoSinSubpayer((String)rowItems.get(0), new BigDecimal((Double)rowItems.get(1)));
                        depositosSinSubpayerMesAnterior.add(dep);
                    }
                }
                dataResult.setDepositosSinSubpayerMesAnterior(depositosSinSubpayerMesAnterior);
                List depositosPorSubpayerResult = (List)queryResults.get(3);
                ArrayList<ConsoleDataResult.DepositoSubpayer> depositosSubpayerMesAnterior = new ArrayList<ConsoleDataResult.DepositoSubpayer>();
                if (!CollectionUtils.isEmpty((Collection)depositosPorSubpayerResult)) {
                    for (Object row : depositosPorSubpayerResult) {
                        List rowItems = (List)row;
                        ConsoleDataResult.DepositoSubpayer dep = new ConsoleDataResult.DepositoSubpayer((String)rowItems.get(0), (String)rowItems.get(1), new BigDecimal((Double)rowItems.get(2)));
                        depositosSubpayerMesAnterior.add(dep);
                    }
                }
                dataResult.setDepositosSubpayerMesAnterior(depositosSubpayerMesAnterior);
                List depositosSinSubpayerMTDResult = (List)queryResults.get(4);
                ArrayList<ConsoleDataResult.DepositoSinSubpayer> depositosSinSubpayerMTD = new ArrayList<ConsoleDataResult.DepositoSinSubpayer>();
                if (!CollectionUtils.isEmpty((Collection)depositosSinSubpayerMTDResult)) {
                    for (Object row : depositosSinSubpayerMTDResult) {
                        List rowItems = (List)row;
                        ConsoleDataResult.DepositoSinSubpayer dep = new ConsoleDataResult.DepositoSinSubpayer((String)rowItems.get(0), new BigDecimal((Double)rowItems.get(1)));
                        depositosSinSubpayerMTD.add(dep);
                    }
                }
                dataResult.setDepositosSinSubpayerMTD(depositosSinSubpayerMTD);
                List depositosPorSubpayerMTDResult = (List)queryResults.get(5);
                ArrayList<ConsoleDataResult.DepositoSubpayer> depositosSubpayerMTD = new ArrayList<ConsoleDataResult.DepositoSubpayer>();
                if (!CollectionUtils.isEmpty((Collection)depositosPorSubpayerMTDResult)) {
                    for (Object row : depositosPorSubpayerMTDResult) {
                        List rowItems = (List)row;
                        ConsoleDataResult.DepositoSubpayer dep = new ConsoleDataResult.DepositoSubpayer((String)rowItems.get(0), (String)rowItems.get(1), new BigDecimal((Double)rowItems.get(2)));
                        depositosSubpayerMTD.add(dep);
                    }
                }
                dataResult.setDepositosSubpayerMTD(depositosSubpayerMTD);
            }
        } else {
            throw new ServiceException(response);
        }
        return dataResult;
    }

    public CompanyAccountsDEPDataResult getCompanyAccountsDEP(String sessionId, RemoteInstance remoteInstance, String token, OperatorWAPI operator) throws ServiceException {
        logger.debug((Object)("Buscando companyAccounts deposito para el operador [" + operator + "]"));
        CompanyAccountsDEPDataResult dataResult = new CompanyAccountsDEPDataResult();
        if (operator != null) {
            GetRightRequestWAPI request = new GetRightRequestWAPI(token, sessionId, operator.getId(), "ORDENPAGO.DEP.ACCOUNTSALLOWED", GetRightRequest.RIGHT_TYPE.GET_CONFIG, GetRightRequest.RESULT_TYPE.COMPANY_ACCOUNT_LIST);
            ResponseWAPI response = this.ebfWAPIService.apiRequest(remoteInstance, (RequestWAPI)request, GetRightResponseWAPI.class);
            dataResult.setNewToken(response.getToken());
            if (response.getResultCode().equals((Object)ResponseWAPI.Codes.OK_GET_RIGHT)) {
                GetRightResponseWAPI getRightResponse = (GetRightResponseWAPI)response;
                List companyAccountWAPIListResult = ((GetRightResponse)getRightResponse.getRightResponses().get(0)).getCompanyAccountWAPIListResult();
                dataResult.setCompanyAccountWAPIListResult(companyAccountWAPIListResult);
                logger.debug((Object)("CompanyAccounts DEP del operador [" + operator + "]: [" + companyAccountWAPIListResult + "]"));
            } else {
                throw new ServiceException(response);
            }
        }
        return dataResult;
    }

    public DefaultOperatorDataResult getDefaultOperator(String sessionId, RemoteInstance remoteInstance, String token, CompanyWAPI companyWAPI) throws ServiceException {
        logger.debug((Object)("Buscando el operador por default para la company [" + companyWAPI + "]"));
        DefaultOperatorDataResult result = new DefaultOperatorDataResult();
        if (companyWAPI != null) {
            DefaultOperatorRequestWAPI request = new DefaultOperatorRequestWAPI(token, sessionId, companyWAPI);
            ResponseWAPI response = this.ebfWAPIService.apiRequest(remoteInstance, (RequestWAPI)request, DefaultOperatorResponseWAPI.class);
            result.setNewToken(response.getToken());
            if (response.getResultCode().equals((Object)ResponseWAPI.Codes.OK_DEFAULT_OPERATOR)) {
                DefaultOperatorResponseWAPI defaultOperatorResponse = (DefaultOperatorResponseWAPI)response;
                OperatorWAPI defaultOperator = defaultOperatorResponse.getDefaultOperator();
                result.setDefaultOperator(defaultOperator);
                logger.debug((Object)("Operador por default de la company [" + companyWAPI + "]: [" + defaultOperator + "]"));
            } else {
                throw new ServiceException(response);
            }
        }
        return result;
    }
}

