/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.cuentasimple.ejb.service;

import ar.com.sdd.cuentasimple.ejb.exception.ApplicationException;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jboss.logging.Logger;

@Stateless
public class ExcelServiceBean {
    private static final Logger logger = Logger.getLogger(ExcelServiceBean.class);

    public <T> List<Pair<ExcelRowStatus, T>> getDataFromExcel(InputStream excelStream, Class<T> clazz, int skipRows, List<ExcelColumnSpecification> columnSpecification) {
        try {
            logger.debug((Object)"Comenzando la importacion de datos desde Excel");
            if (CollectionUtils.isEmpty(columnSpecification)) {
                throw new ApplicationException("No se especificaron columnas");
            }
            ArrayList<Pair<ExcelRowStatus, T>> result = new ArrayList<Pair<ExcelRowStatus, T>>();
            logger.debug((Object)"Precompilando las columnas");
            ArrayList<Script> compiledColumnScripts = new ArrayList<Script>(columnSpecification.size());
            GroovyShell groovyShell = new GroovyShell();
            if (!CollectionUtils.isEmpty(columnSpecification)) {
                for (ExcelColumnSpecification column : columnSpecification) {
                    if (column.columnExpression != null) {
                        compiledColumnScripts.add(groovyShell.parse(column.columnExpression));
                        continue;
                    }
                    compiledColumnScripts.add(null);
                }
            }
            Workbook wb = WorkbookFactory.create((InputStream)excelStream);
            Sheet sheet = wb.getSheetAt(0);
            logger.debug((Object)"Recorriendo las filas");
            int totalRows = sheet.getLastRowNum() + 1;
            if (totalRows > skipRows) {
                for (int i = skipRows; i < totalRows; ++i) {
                    ExcelRowStatus rowResult;
                    Object obj = null;
                    try {
                        obj = clazz.newInstance();
                        Row row = sheet.getRow(i);
                        int j = 0;
                        for (Script script : compiledColumnScripts) {
                            if (script != null) {
                                Cell cell = row.getCell(j);
                                Binding binding = new Binding();
                                binding.setVariable("obj", obj);
                                binding.setVariable("cell", (Object)cell);
                                script.setBinding(binding);
                                script.run();
                            }
                            ++j;
                        }
                        rowResult = new ExcelRowStatus(i, RowStatus.ROW_STATUS_OK);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Hubo un error en la fila [" + (i + 1) + "]"), (Throwable)e);
                        obj = null;
                        rowResult = new ExcelRowStatus(i, RowStatus.ROW_STATUS_ERROR);
                    }
                    result.add(Pair.of((Object)rowResult, obj));
                }
            } else {
                logger.warn((Object)("No se procesa el excel porque se pidio saltar [" + skipRows + "] filas y en el archivo solo hay [" + totalRows + "] filas"));
            }
            return result;
        }
        catch (Exception e) {
            throw new ApplicationException("Hubo un error al intentar importar desde Excel", e);
        }
    }

    public static class ExcelRowStatus {
        public int line;
        public RowStatus rowStatus;

        public ExcelRowStatus(int line, RowStatus rowStatus) {
            this.line = line;
            this.rowStatus = rowStatus;
        }
    }

    public static enum RowStatus {
        ROW_STATUS_OK,
        ROW_STATUS_ERROR;

    }

    public static class ExcelColumnSpecification {
        public String columnExpression;

        public ExcelColumnSpecification(String columnExpression) {
            this.columnExpression = columnExpression;
        }

        public static List<ExcelColumnSpecification> builder(String ... columnExpressions) {
            ArrayList<ExcelColumnSpecification> result = new ArrayList<ExcelColumnSpecification>();
            if (columnExpressions != null) {
                for (String expression : columnExpressions) {
                    result.add(new ExcelColumnSpecification(expression));
                }
            }
            return result;
        }
    }
}

