/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.cuentasimple.ejb.service;

import ar.com.sdd.cuentasimple.ejb.application.CuentaSimpleApplicationBean;
import ar.com.sdd.cuentasimple.ejb.entity.RemoteInstance;
import ar.com.sdd.cuentasimple.ejb.exception.ApplicationException;
import ar.com.sdd.cuentasimple.ejb.pojo.BoletaContainer;
import ar.com.sdd.cuentasimple.ejb.pojo.IdCard;
import ar.com.sdd.cuentasimple.ejb.service.PdfServiceBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import javax.activation.DataSource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.jboss.logging.Logger;

@Stateless
public class MailServiceBean {
    private static final Logger logger = Logger.getLogger(MailServiceBean.class);
    @EJB
    PdfServiceBean pdfService;
    @EJB
    CuentaSimpleApplicationBean csApp;

    public void mailIdCards(RemoteInstance remoteInstance, List<IdCard> idCards, String emailAddress) {
        if (!CollectionUtils.isEmpty(idCards)) {
            try {
                logger.debug((Object)("Enviando mail con tarjetas a [" + emailAddress + "]"));
                MultiPartEmail mail = this.createMail(emailAddress);
                StringBuilder listaBancos = new StringBuilder();
                String sep = "";
                for (IdCard idCard : idCards) {
                    listaBancos.append(sep);
                    listaBancos.append(idCard.getCompanyAccount().getBank().getName());
                    sep = ", ";
                }
                Object bancosArg = idCards.size() > 1 ? "para los bancos " : "para el banco ";
                bancosArg = (String)bancosArg + listaBancos;
                String razonSocialArg = idCards.get(0).getOperator().getCompanyWAPI().getRazonSocial();
                String subject = this.csApp.getPropertyManager().getProperty("mail.subject.idcards");
                String message = this.csApp.getPropertyManager().getProperty("mail.body.idcards");
                subject = MessageFormat.format(subject, bancosArg);
                message = MessageFormat.format(message, razonSocialArg, bancosArg);
                mail.setSubject(subject);
                mail.setMsg(message);
                for (IdCard idCard : idCards) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    this.pdfService.generateIdCardPDF(remoteInstance, idCard, outputStream);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                    ByteArrayDataSource source = new ByteArrayDataSource((InputStream)inputStream, "application/pdf");
                    mail.attach((DataSource)source, idCard.getCompanyAccount().getBank().getName() + ".pdf", "Tarjeta para Banco " + idCard.getCompanyAccount().getBank().getName());
                }
                mail.send();
                logger.debug((Object)"Mail de tarjetas enviado correctamente");
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ApplicationException("Error al enviar un mail a [" + emailAddress + "]", e);
            }
        } else {
            throw new ApplicationException("No se puede enviar mail porque no vinieron tarjetas");
        }
    }

    public void mailBoleta(RemoteInstance remoteInstance, BoletaContainer boletaContainer, String emailAddress) {
        if (boletaContainer != null) {
            try {
                logger.debug((Object)("Enviando mail con boleta a [" + emailAddress + "]"));
                MultiPartEmail mail = this.createMail(emailAddress);
                String subject = this.csApp.getPropertyManager().getProperty("mail.subject.boleta");
                String message = this.csApp.getPropertyManager().getProperty("mail.body.boleta");
                mail.setSubject(subject);
                mail.setMsg(message);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                this.pdfService.generateBoletaPDF(remoteInstance, boletaContainer, outputStream);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                ByteArrayDataSource source = new ByteArrayDataSource((InputStream)inputStream, "application/pdf");
                mail.attach((DataSource)source, boletaContainer.getBoleta().getLegalDocRef() + ".pdf", "Boleta para Banco " + boletaContainer.getBoleta().getCollectorAccount().getBank().getName());
                mail.send();
                logger.debug((Object)"Mail de boleta enviado correctamente");
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ApplicationException("Error al enviar un mail a [" + emailAddress + "]", e);
            }
        } else {
            throw new ApplicationException("No se puede enviar mail porque no vino una boleta");
        }
    }

    private MultiPartEmail createMail(String emailAddress) throws EmailException {
        MultiPartEmail mail = new MultiPartEmail();
        String hostName = this.csApp.getPropertyManager().getProperty("mail.hostname");
        Integer smtpPort = this.csApp.getPropertyManager().getIntegerProperty("mail.smtpport");
        String authUser = this.csApp.getPropertyManager().getProperty("mail.authuser");
        String authPass = this.csApp.getPropertyManager().getProperty("mail.authpass");
        String forcedTo = this.csApp.getPropertyManager().getProperty("mail.forced.to");
        String fromEmail = this.csApp.getPropertyManager().getProperty("mail.from.mail");
        String fromName = this.csApp.getPropertyManager().getProperty("mail.from.name");
        mail.setHostName(hostName);
        mail.setSmtpPort(smtpPort.intValue());
        if (!StringUtils.isEmpty((CharSequence)authUser)) {
            mail.setAuthentication(authUser, authPass);
        }
        mail.setFrom(fromEmail, fromName);
        if (this.csApp.isDESA() || this.csApp.isQA()) {
            mail.addTo(forcedTo);
        } else {
            mail.addTo(emailAddress);
        }
        logger.debug((Object)("Parametros del mail: " + hostName + ":" + smtpPort + "@" + authUser + ":*******   from:" + fromEmail + "<" + fromName + ">   to:" + emailAddress + "  forcedto:" + forcedTo));
        return mail;
    }
}

