package ar.com.sdd.cvsaapi.core

import ar.com.sdd.commons.rest.core.RestConnector
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment
import ar.com.sdd.commons.rest.core.RestConnectorException
import ar.com.sdd.commons.rest.core.RestSecurityManager
import ar.com.sdd.cvsaapi.core.io.ConsultaActivoDigitalEstadoResponse
import ar.com.sdd.cvsaapi.core.io.ConsultaRankingPagadoresResponse
import org.apache.log4j.Logger
import java.text.SimpleDateFormat
import java.util.*
import javax.ws.rs.client.Invocation

open class CvsApiConnector(context: CvsaApiConnectorContext) : RestSecurityManager {

    private val log: Logger = Logger.getLogger(CvsApiConnector::class.java)

    private val restConnector: RestConnector
    private val username: String
    private val password: String


    init {
        val environment = RestConnectorEnvironment(context.getCvsaApiBaseUrl())
        restConnector = RestConnector(environment, this)
        username = context.getCvsaApiBaseUsername()
        password = context.getCvsaApiBasePassword()

        log.debug("Creando CvsApiConnector para url [${context.getCvsaApiBaseUrl()}], username [$username], password [$password]")
    }

    @Deprecated("Esta operacion no esta vigente")
    fun consultarRankingPagadores(tipoInstrumento: String?, cuit: String?, fechaPago: Date?, pagina: Int?, itemsPagina: Int?) : ConsultaRankingPagadoresResponse {
        val path = StringBuilder("/gestionarfacturaservice.php/$username/$password/fncconsultarrankingpagadores")

        if (!tipoInstrumento.isNullOrEmpty()) {
            path.append("/$tipoInstrumento")
        } else {
            path.append("/ ") //un espacio
        }
        if (!cuit.isNullOrEmpty()) {
            path.append("/$cuit")
        } else {
            path.append("/ ") //un espacio
        }
        if (fechaPago != null) {
            path.append("/").append(SimpleDateFormat("dd-MM-yyyy").format(fechaPago))
        } else {
            throw RestConnectorException("La fecha de pago es requerida")
        }
        if (pagina != null) {
            path.append("/$pagina")
        } else {
            path.append("/ ") //un espacio
        }
        if (itemsPagina != null) {
            path.append("/$itemsPagina")
        } else {
            path.append("/ ") //un espacio
        }
        path.append("/") //barra final

        log.debug("[consultarRankingPagadores] Request con tipoInstrumento [$tipoInstrumento], cuit [$cuit], fechaPago [$fechaPago], pagina [$pagina], itemsPagina [$itemsPagina], path [$path]")
        val response = restConnector.genericGet(null, ConsultaRankingPagadoresResponse::class.java, path.toString())
        log.debug("[consultarRankingPagadores] Response [$response]")
        return response

    }

    fun consultarActivoDigitalEstado(tipoInstrumento: String?, idInstrumento: String?)  : ConsultaActivoDigitalEstadoResponse {
        val path = StringBuilder("/gestionarfacturaservice.php/$username/$password/fncconsultaractivodigitalestado")

        if (!tipoInstrumento.isNullOrEmpty()) {
            path.append("/$tipoInstrumento")
        } else {
            throw RestConnectorException("El tipo de instrumento es requerido")
        }

        if (!idInstrumento.isNullOrEmpty()) {
            path.append("/$idInstrumento")
        } else {
            throw RestConnectorException("El id de instrumento es requerido")
        }

        path.append("/") //barra final

        log.debug("[consultarActivoDigitalEstado] Request con tipoInstrumento [$tipoInstrumento], idInstrumento [$idInstrumento], path [$path]")
        val response = restConnector.genericGet(null, ConsultaActivoDigitalEstadoResponse::class.java, path.toString())
        log.debug("[consultarActivoDigitalEstado] Response [$response]")
        return response

    }

    override fun addHeaders(builder: Invocation.Builder?): Invocation.Builder? {
        return builder
    }

}