package ar.com.sdd.cvsaapi.core.io

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import java.math.BigDecimal
import java.util.*

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class ConsultaRankingPagadoresResponse {

    /**
     * Resultado de la operación
     */
    var strmsjresp: String? = null

    /**
     * Mensaje complementario
     */
    var strmsjadic: String? = null

    /**
     * Tabla global de activos digitales y estado de deuda
     */
    var strrspacti: String? = null

    /**
     * Instrumento
     */
    var strfacinst: String? = null

    /**
     * Código CVSA
     */
    var strfaciden: String? = null

    /**
     * Moneda
     */
    var strfacmone: String? = null

    /**
     * Importe
     */
    var numfacimpo: BigDecimal? = null

    /**
     * Fecha pago o vencimiento
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy")
    var datfacpago: Date? = null

    /**
     * Razón social pagador
     */
    var strfacdeno: String? = null

    /**
     * CUIT pagador
     */
    var strfaccuit: String? = null

    /**
     * Identificador
     */
    var strfacnume: String? = null

    /**
     * Fecha fondos
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy")
    var datfacfonx: Date? = null

    /**
     * Estado
     */
    var strestdeno: String? = null

    override fun toString(): String {
        return "ConsultaRankingPagadoresResponse(strmsjresp=$strmsjresp, strmsjadic=$strmsjadic, strrspacti=$strrspacti, strfacinst=$strfacinst, strfaciden=$strfaciden, strfacmone=$strfacmone, numfacimpo=$numfacimpo, datfacpago=$datfacpago, strfacdeno=$strfacdeno, strfaccuit=$strfaccuit, strfacnume=$strfacnume, datfacfonx=$datfacfonx, strestdeno=$strestdeno)"
    }

}