package ar.com.sdd.cvsaapi.core.io

import ar.com.sdd.cvsaapi.core.model.PedidoTransferenciaTitularidad
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import java.util.*

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class ConsultarTransferenciaTitularidadLoteRequest {

    /**
     * User
     */
    var strusucodi: String? = null

    /**
     * Password
     */
    var strusupass: String? = null

    /**
     * Funcion fncconsultartransferenciatitularidadlote
     */
    var strwsmetod: String? = null

    /**
     * Cuenta depositante o agente
     */
    var strdepiden: String? = null

    /**
     * Fecha alta
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy")
    var dattrfalta: Date? = null

    /**
     * Lote
     */
    var strlotiden: String? = null

    override fun toString(): String {
        return "ConsultarTransferenciaTitularidadLoteRequest(strusucodi=$strusucodi, strusupass=$strusupass, strwsmetod=$strwsmetod, strdepiden=$strdepiden, dattrfalta=$dattrfalta, strlotiden=$strlotiden)"
    }

}