package ar.com.sdd.cvsaapi.core.model

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import java.util.*

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class ResumenTransferenciaTitularidad {

    /**
     * Depositante
     */
    var strdepiden: String? = null

    /**
     * Fecha alta
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy")
    var dattrfalta: Date? = null

    /**
     * Lote
     */
    var strlotiden: String? = null

    /**
     * strtrforde
     */
    var strtrforde: String? = null

    /**
     * Modalidad transferencia
     */
    var strtrftipo: String? = null

    /**
     * Cantidad
     */
    var inttrfcant: String? = null

    /**
     * Fecha operacion
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy")
    var dattrfoper: Date? = null

    /**
     * Código CVSA
     */
    var strfaciden: String? = null

    /**
     * Cuenta emisor
     */
    var strorgemis: String? = null

    /**
     * Subcuenta emisor
     */
    var strcueemis: String? = null

    /**
     * Cuenta receptor
     */
    var strorgrece: String? = null

    /**
     * Subcuenta receptor
     */
    var strcuerece: String? = null

    /**
     * Estado
     */
    var strtrfesta: String? = null

    /**
     * Fecha estado
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy")
    var dattrfesta: Date? = null

    /**
     * Observaciones
     */
    var strtrfobse: String? = null

    /**
     * Pedido
     */
    var strtrfpedi: String? = null

    override fun toString(): String {
        return "ResumenTransferenciaTitularidad(strdepiden=$strdepiden, dattrfalta=$dattrfalta, strlotiden=$strlotiden, strtrforde=$strtrforde, strtrftipo=$strtrftipo, inttrfcant=$inttrfcant, dattrfoper=$dattrfoper, strfaciden=$strfaciden, strorgemis=$strorgemis, strcueemis=$strcueemis, strorgrece=$strorgrece, strcuerece=$strcuerece, strtrfesta=$strtrfesta, dattrfesta=$dattrfesta, strtrfobse=$strtrfobse, strtrfpedi=$strtrfpedi)"
    }

}