package ar.com.sdd.cvsaapi.core

import ar.com.sdd.commons.rest.core.RestConnector
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment
import ar.com.sdd.commons.rest.core.RestConnectorException
import ar.com.sdd.commons.rest.core.RestSecurityManager
import ar.com.sdd.cvsaapi.core.io.*
import ar.com.sdd.cvsaapi.core.model.PedidoTransferenciaTitularidad
import org.apache.log4j.Logger
import java.net.URLEncoder
import java.nio.charset.StandardCharsets
import java.text.SimpleDateFormat
import java.util.*
import javax.ws.rs.client.Invocation

open class CvsApiConnector(context: CvsaApiConnectorContext) : RestSecurityManager {

    private val log: Logger = Logger.getLogger(CvsApiConnector::class.java)

    private val restConnector: RestConnector
    private val username: String
    private val password: String


    init {
        val environment = RestConnectorEnvironment(context.getCvsaApiBaseUrl())
        restConnector = RestConnector(environment, this)
        username = context.getCvsaApiBaseUsername()
        password = context.getCvsaApiBasePassword()

        log.debug("Creando CvsApiConnector para url [${context.getCvsaApiBaseUrl()}], username [$username], password [$password]")
    }

    @Deprecated("Esta operacion no esta vigente")
    fun consultarRankingPagadores(tipoInstrumento: String?, cuit: String?, fechaPago: Date?, pagina: Int?, itemsPagina: Int?): ConsultaRankingPagadoresResponse {
        val path = StringBuilder("/gestionarfacturaservice.php/$username/$password/fncconsultarrankingpagadores")

        if (!tipoInstrumento.isNullOrEmpty()) {
            path.append("/$tipoInstrumento")
        } else {
            path.append("/ ") //un espacio
        }
        if (!cuit.isNullOrEmpty()) {
            path.append("/$cuit")
        } else {
            path.append("/ ") //un espacio
        }
        if (fechaPago != null) {
            path.append("/").append(SimpleDateFormat("dd-MM-yyyy").format(fechaPago))
        } else {
            throw RestConnectorException("La fecha de pago es requerida")
        }
        if (pagina != null) {
            path.append("/$pagina")
        } else {
            path.append("/ ") //un espacio
        }
        if (itemsPagina != null) {
            path.append("/$itemsPagina")
        } else {
            path.append("/ ") //un espacio
        }
        path.append("/") //barra final


        var urlPath= URLEncoder.encode(path.toString(), StandardCharsets.UTF_8)
        log.debug("[consultarRankingPagadores] Request con tipoInstrumento [$tipoInstrumento], cuit [$cuit], fechaPago [$fechaPago], pagina [$pagina], itemsPagina [$itemsPagina], path [$urlPath]")
        val response = restConnector.genericGet(null, ConsultaRankingPagadoresResponse::class.java, urlPath)
        log.debug("[consultarRankingPagadores] Response [$response]")
        return response

    }

    fun consultarActivoDigitalEstado(tipoInstrumento: String?, idInstrumento: String?): ConsultaActivoDigitalEstadoResponse {
        val path = StringBuilder("/gestionarfacturaservice.php/$username/$password/fncconsultaractivodigitalestado")

        if (!tipoInstrumento.isNullOrEmpty()) {
            path.append("/$tipoInstrumento")
        } else {
            throw RestConnectorException("El tipo de instrumento es requerido")
        }

        if (!idInstrumento.isNullOrEmpty()) {
            path.append("/$idInstrumento")
        } else {
            throw RestConnectorException("El id de instrumento es requerido")
        }

        path.append("/") //barra final

        var urlPath= URLEncoder.encode(path.toString(), StandardCharsets.UTF_8)
        log.debug("[consultarActivoDigitalEstado] Request con tipoInstrumento [$tipoInstrumento], idInstrumento [$idInstrumento], path [$urlPath]")
        val response = restConnector.genericGet(null, ConsultaActivoDigitalEstadoResponse::class.java, urlPath)
        log.debug("[consultarActivoDigitalEstado] Response [$response]")
        return response

    }

    fun recibirTransferenciaTitularidadLote(cuentaAgente: String, tipoTransferencia: String, transferencias: List<PedidoTransferenciaTitularidad>): RecibirTransferenciaTitularidadLoteResponse {
        val path = "/gestionarfacturaservice.php"
        val request = RecibirTransferenciaTitularidadLoteRequest()
        request.strusucodi = username
        request.strusupass = password
        request.strwsmetod = "fncrecibirtransferenciatitularidadlote"
        request.strdepiden = padNum(cuentaAgente, 4)
        request.strtrftipo = tipoTransferencia
        request.strtrftitu = transferencias
        //Me aseguro el padding correcto
        for (transferencia in transferencias) {
            transferencia.strorgemis = padNum(transferencia.strorgemis, 4)
            transferencia.strcueemis = padNum(transferencia.strcueemis, 9)
            transferencia.strorgrece = padNum(transferencia.strorgrece, 4)
            transferencia.strcuerece = padNum(transferencia.strcuerece, 9)
        }

        log.debug("[recibirTransferenciaTitularidadLote] Request [$request], path [$path]")
        val response = restConnector.genericPost(request, RecibirTransferenciaTitularidadLoteResponse::class.java, path)
        log.debug("[recibirTransferenciaTitularidadLote] Response [$response]")

        return response
    }

    fun consultarTransferenciaTitularidadLote(cuentaAgente: String, fechaAlta: Date, lote: String): ConsultarTransferenciaTitularidadLoteResponse {
        val path = "/gestionarfacturaservice.php"
        val request = ConsultarTransferenciaTitularidadLoteRequest()
        request.strusucodi = username
        request.strusupass = password
        request.strwsmetod = "fncconsultartransferenciatitularidadlote"
        request.strdepiden = padNum(cuentaAgente, 4)
        request.dattrfalta = fechaAlta
        request.strlotiden = padNum(lote, 2)

        log.debug("[consultarTransferenciaTitularidadLote] Request [$request], path [$path]")
        val response = restConnector.genericPost(request, ConsultarTransferenciaTitularidadLoteResponse::class.java, path)
        log.debug("[consultarTransferenciaTitularidadLote] Response [$response]")

        return response

    }

    override fun addHeaders(builder: Invocation.Builder?): Invocation.Builder? {
        return builder
    }

    override fun getDisableHTTPSErrors(): Boolean {
        return false
    }

    private fun padNum(str: String?, length: Int) : String? {
        if (str == null) return null
        return str.padStart(length, '0');
    }

}