package ar.com.sdd.cvsaapi.core.model

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import java.util.*

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class PedidoTransferenciaTitularidad {

    /**
     * Fecha operación
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy")
    var dattrfoper: Date? = null

    /**
     * Código CVSA
     */
    var strfaciden: String? = null

    /**
     * Cuenta emisor
     */
    var strorgemis: String? = null

    /**
     * Subcuenta emisor
     */
    var strcueemis: String? = null

    /**
     * Cuenta receptor
     */
    var strorgrece: String? = null

    /**
     * Subcuenta receptor
     */
    var strcuerece: String? = null

    override fun toString(): String {
        return "PedidoTransferenciaTitularidad(dattrfoper=$dattrfoper, strfaciden=$strfaciden, strorgemis=$strorgemis, strcueemis=$strcueemis, strorgrece=$strorgrece, strcuerece=$strcuerece)"
    }


}