package ar.com.sdd.debin.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public interface DebinConst {

    String RESPUESTA_OK = "00";
    String GIRE_ENDPOINT = "gireciti";
    String RESPUESTA_ESTADO_NO_MODIFICABLE = "87";
    String CONSULTA_ALIAS_OK = "0100";
    String LIMITES_CREADOS_OK = "4100";
    String CONSULTA_CONSUMOS_OK = "4200";
    String CONSULTA_LIMITES_OK = "4300";
    String CONSULTA_LIMITES_PRIMERA_VEZ_ERROR = "4357";
    String PRE_AUTORIZACION_ENCONTRADA_OK = "5300";
    String CONTRA_CARGO_OK = "5500";

    enum Concepto {
        ALQ("Alquileres"),
        CUO("Cuotas"),
        EXP("Expensas"),
        FAC("Facturas"),
        PRE("Prestamos"),
        SEG("Seguros"),
        HON("Honorarios"),
        HAB("Haberes"),
        VAR("Varios"),;

        private String desc;

        Concepto(String desc) {
            this.desc = desc;
        }

        @JsonCreator
        public static Concepto forValue(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            return Concepto.valueOf(value);
        }

        public String getDesc() {
            return desc;
        }

        @JsonValue
        public String toValue() {
            return this.toString();
        }

    }

    enum Moneda {
        ARS("032", "Pesos", "ARS"),
        USD("840", "Dolares", "USD"),;

        private String code;
        private String desc;
        private String ebfCode;

        Moneda(String code, String desc, String ebfCode) {
            this.code = code;
            this.desc = desc;
            this.ebfCode = ebfCode;
        }

        @JsonCreator
        public static Moneda forValue(String code) {
            if (code == null || code.equals("")) {
                return null;
            }
            for (Moneda moneda : Moneda.values()) {
                if (moneda.code.equals(code)) {
                    return moneda;
                }
            }
            throw new RuntimeException("No existe la moneda para el codigo [" + code + "]");
        }

        public static Moneda forValueEbf(String ebfCode) {
            if (ebfCode == null || ebfCode.equals("")) {
                return null;
            }
            for (Moneda moneda : Moneda.values()) {
                if (moneda.ebfCode.equals(ebfCode)) {
                    return moneda;
                }
            }
            throw new RuntimeException("No existe la moneda para el codigo ebf [" + ebfCode + "]");
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        public String getEbfCode() {
            return ebfCode;
        }

        @JsonValue
        public String toValue() {
            return this.code;
        }


    }


    enum TipoCuentaAlias {
        CAJA_AHORRO_PESOS("10"),
        CUENTA_CORRIENTE_PESOS("20"),
        CAJA_AHORRO_DOLARES("11"),
        CUENTA_CORRIENTE_DOLARES("21"),;

        private String code;

        TipoCuentaAlias(String code) {
            this.code = code;
        }

        @JsonCreator
        public static TipoCuentaAlias forValue(String code) {
            if (code == null || code.equals("")) {
                return null;
            }
            for (TipoCuentaAlias tipoCuentaAlias : TipoCuentaAlias.values()) {
                if (tipoCuentaAlias.code.equals(code)) {
                    return tipoCuentaAlias;
                }
            }
            throw new RuntimeException("No tipo de cuenta para el codigo [" + code + "]");
        }

        public String getCode() {
            return code;
        }

        @JsonValue
        public String toValue() {
            return this.code;
        }
    }

    enum TipoPersonaAlias {
        F, f,
        J, j;

        @JsonCreator
        public static TipoPersonaAlias forValue(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            return TipoPersonaAlias.valueOf(value);
        }

        @JsonValue
        public String toValue() {
            return this.toString();
        }

    }

    enum Periodo {
        DIA("Dia"),
        MES("Mes"),;

        private String desc;

        Periodo(String desc) {
            this.desc = desc;
        }

        @JsonCreator
        public static Periodo forValue(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            return Periodo.valueOf(value);
        }

        public String getDesc() {
            return desc;
        }

        @JsonValue
        public String toValue() {
            return this.toString();
        }
    }


    enum TipoDebin {
        debin,
        transferencia,
        contracargo;

        @JsonCreator
        public static TipoDebin forValue(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            return TipoDebin.valueOf(value.toLowerCase());
        }

        @JsonValue
        public String toValue() {
            return this.toString();
        }
    }

}
