package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Respuesta {

    private String descripcion;
    /**
     ConsultaComprador
     00: OK
     75: Cuit Incorrecto
     05: Comprador no existe
     99: Error de sistema

     ConsultaVendedor
     00: Ok
     07: Vendedor no adherido
     99: Error de sistema
     63: Entidad de consulta incorrecta
     44: Datos incorrectos
     76: CUIT Mal formado
     74: CBU Mal formado

     ConsumosConsultaVendedor
     4200: CONSUMOS ENCONTRADOS CON EXITO
     4257: CUIT NO ENCONTRADO
     4258: CUIT MAL FORMULADO
     4259: CONSUMOS NO ENCONTRADOS, ERROR DE DATOS
     4299: ERROR GENERAL - BUSQUEDA DE CONSUMOS

     PedidoRecurrenciaVendedor
     4400: PEDIDO DE RECURRENCIA ENVIADO CON ÉXITO
     4444: ERROR DE PERIODO
     4445: CUENTA DE COMPRADOR INEXISTENTE
     4446: COMPRADOR INEXISTENTE
     4447: VENDEDOR NO AUTORIZADO
     4448: VENDEDOR INACTIVO
     4449: ERROR AL INSERTAR LOS DATOS
     4450: ERROR DE IMPORTE MAXIMO POR DEBIN
     4451: ERROR DE IMPORTE MAXIMO
     4452: ERROR CANTIDAD MAXIMA DE DEBINES
     4453: ERROR DE CUIT MAL FORMULADO VENDEDOR
     4454: ERROR DE CUIT MAL FORMULADO COMPRADOR
     4455: ERROR DE CBU MAL FORMULADO COMPRADOR
     4456: ERROR DE CONCEPTO
     4457: ERROR DE DESCRIPCION
     4458: ERROR DE ENVIO A COMPRADOR
     4459: PEDIDO DE RECURRENCIA NO ENVIADO, ERROR DE DATOS
     4499 ERROR GENERAL - PEDIDO DE RECURRENCIA
     4500: RECURRENCIA ACEPTADA
     4550: RECURRENCIA RECHAZADA

     CompradorRecurrenciaListaComprador/VendedorRecurrenciaListaVendedor
     5400: PRE-AUTORIZACIONES ENCONTRADAS CON EXITO
     5451: PAGINA LISTADO INCORRECTO
     5451: TAMAÑO LISTADO INCORRECTO
     5452: CODIGO INCORRECTO
     5453: CBU MAL FORMULADO COMPRADOR
     5454: CUIT NO ENCONTRADO
     5455: CUIT MAL FORMULADO VENDEDOR
     5456: CUIT NO ENCONTRADO VENDEDOR
     5457: CUIT NO ENCONTRADO
     5458: CUIT MAL FORMULADO
     5459: PRE-AUTORIZACIONES NO ENCONTRADAS, ERROR DE DATOS
     5499: ERROR GENERAL - BUSQUEDA DE PREAUTORIZACIONES

     CompradorRecurrenciaComprador/VendedorRecurrenciaVendedor
     5300: PRE-AUTORIZACION ENCONTRADA CON EXITO
     5310: PRE-AUTORIZACION NO ENCONTRADA
     5357: CUIT NO ENCONTRADO
     5358: CUIT MAL FORMULADO
     5359: PRE-AUTORIZACION NO ENCONTRADOS, ERROR DE DATOS
     5399: ERROR GENERAL - BUSQUEDA DE PREAUTORIZACION

     /Comprador/AdherirRecurrencia
     5200: ADHESION DE RECURRENCIA EXITOSA
     5210: BAJA DE ADHESION DE RECURRENCIA EXITOSA
     5220: BAJA DE ADHESION POR NO ACTIVIDAD
     5230: ADHESION OBSOLETA, SUSTITUIDA POR UNA NUEVA
     5244: PERIODO ERRONEO
     5245: DETALLE O CONCEPTO ERRONEO
     5246: CANTIDAD ERRONEA
     5247: MONTO DE DEBIN ERRONEO
     5248: MONTO DE PERIODO ERRONEO
     5249: MONEDA INCORRECTA
     5259: ERROR DE DATOS ENVIADOS
     5251: ERROR DE ESTADO
     5252: ADHESION EXPIRADA
     5253: ERROR AL GUARDAR LOS DATOS
     5254: ERROR AL DAR DE BAJA LA ADHESION
     5255: CUIT MAL FORMULADO VENDEDOR
     5256: VENDEDOR INACTIVO/INEXISTENTE
     5257: COMPRADOR INACTIVO/INEXISTENTE
     5258: CUIT MAL FORMULADO COMPRADOR
     5259: ERROR DE ADHESION DE PREAUTORIZACION, ERROR DE DATOS
     5299: ERROR GENERAL – ADHESION

     10: Cuit mal formulado Vendedor/Comprador
     81: Faltan datos del comrpador
     71: Alias mal formulado del comprador
     06: CBU mal formulada Vendedor/Comprador
     56: Datos mal formulados CBU/Banco/Sucursal
     72: Monto fuera del rango minimo o maximo permitido
     77: Moneda inexistente
     79: Descripcion excede longitud maxima permitida
     73: Tiempo de expiracion no permitido
     80: Banco de token incorrecto

     ConfirmaDebito
     00: Aceptado por el cliente y Debitado por el Banco.
     01: Aceptado por el cliente y pendiente de Débito. Se debitara en Endpoint Online
     02: Aceptado por el cliente y pendiente de Débito. Se debitara en Endpoint Offline
     10: Rechazado por el cliente
     11: Rechazado por el cliente, desconociendo el origen del DEBIN
     20: Sin saldo en la cuenta
     30: Otros problemas con la cuenta de Débito
     35: No existe la cuenta / fue dada de baja
     40: Otros problemas
     45: Rechazo por Scoring Alto

     ListarDebinResponse
     00: Ok
     85: No se obtuvieron resultados con los filtros seleccionados
     63: Entidad de token incorrecta
     22: Faltan datos datos de CUIT. (Es necesario enviar CUIT de comprador o vendedor, alguno de los dos al menos)
     10: Cuit mal formulado
     06: CBU mal formulado
     56: Datos mal formulados CBU/Banco
     99: Error de sistema
     12: Error general de búsqueda/dato

     SolicitudContraCargoComprador
     5500: CONTRA-CARGO REALIZADO CORRECTAMENTE
     5510: CONTRA-CARGO FALLIDO – DATOS INCONGRUENTES
     5547: MOTIVO INCORRECTO
     5548: TIPO MONEDA ERRONEA
     5549: TIPO ERRONEO
     5550: ID ERRONEO
     5551: CBU MAL FORMULADO VENDEDOR
     5552: CBU NO ENCONTRADO VENDEDOR
     5553: CBU MAL FORMULADO COMPRADOR
     5554: CBU NO ENCONTRADO COMPRADOR
     5555: CUIT MAL FORMULADO VENDEDOR
     5556: CUIT NO ENCONTRADO VENDEDOR
     5557: CUIT NO ENCONTRADO COMPRADOR
     5558: CUIT MAL FORMULADO COMPRADOR
     5559: ERROR DE DATOS
     5599: ERROR GENERAL

     AvisoOperacionFinalizada
     00: La operacion Finalizo correctamente.
     75: Sin Saldo en cuenta Origen del debito.
     76: Sin Disponible en cuenta Origen del debito.
     77: Problemas con el Debito.
     78: Problemas con el Credito. REVERSAR
     99: Error de Sistema. REVERSAR

     */
    private String codigo;

    public String getDescripcion() {
        return descripcion;
    }

    @JsonGetter("Descripcion")
    public String getDescripcionMalCapitalizado() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @JsonSetter("Descripcion")
    public void setDescripcionMalCapitalizado(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getCodigo() {
        return codigo;
    }

    @JsonGetter("Codigo")
    public String getCodigoMalCapitalizado() {
        return codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @JsonSetter("Codigo")
    public void setCodigoMalCapitalizado(String codigo) {
        this.codigo = codigo;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Respuesta respuesta = (Respuesta) o;

        if (descripcion != null ? !descripcion.equals(respuesta.descripcion) : respuesta.descripcion != null)
            return false;
        return codigo != null ? codigo.equals(respuesta.codigo) : respuesta.codigo == null;
    }

    @Override
    public int hashCode() {
        int result = descripcion != null ? descripcion.hashCode() : 0;
        result = 31 * result + (codigo != null ? codigo.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Respuesta ["
                + ((descripcion != null) ? "descripcion=" + descripcion + ", " : "")
                + ((codigo != null) ? "codigo=" + codigo : "")
                + "]";
    }

}
