package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Alias;
import ar.com.sdd.debin.entity.CuentaAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConsultarAliasRequest {

    private Alias alias;
    private CuentaAlias cuenta;

    public ConsultarAliasRequest() {
    }

    public Alias getAlias() {
        return alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public CuentaAlias getCuenta() {
        return cuenta;
    }

    public void setCuenta(CuentaAlias cuenta) {
        this.cuenta = cuenta;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultarAliasRequest that = (ConsultarAliasRequest) o;

        if (alias != null ? !alias.equals(that.alias) : that.alias != null) return false;
        return cuenta != null ? cuenta.equals(that.cuenta) : that.cuenta == null;
    }

    @Override
    public int hashCode() {
        int result = alias != null ? alias.hashCode() : 0;
        result = 31 * result + (cuenta != null ? cuenta.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConsultarAliasRequest [" +
                "alias=" + alias +
                ", cuenta=" + cuenta +
                ']';
    }

}
